/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormNode;
import visad.data.FunctionFormFamily;
import visad.data.bio.LociForm;
import visad.data.dods.DODSForm;
import visad.data.fits.FitsForm;
import visad.data.gif.GIFForm;
import visad.data.gis.DemFamily;
import visad.data.hdfeos.HdfeosAdaptedForm;
import visad.data.jai.JAIForm;
import visad.data.mcidas.AreaForm;
import visad.data.mcidas.MapForm;
import visad.data.mcidas.PointForm;
import visad.data.netcdf.Plain;
import visad.data.text.TextForm;
import visad.data.vis5d.Vis5DFamily;
import visad.data.visad.VisADForm;

public class DefaultFamily
extends FunctionFormFamily {
    private static FormNode[] list = new FormNode[100];
    private static boolean listInitialized = false;

    private static void buildList() {
        int i = 0;
        try {
            DefaultFamily.list[i] = DODSForm.dodsForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new FitsForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new GIFForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new LociForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new HdfeosAdaptedForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new Plain();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new Vis5DFamily("vis5d");
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new VisADForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new VisADForm(true);
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new AreaForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new PointForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new MapForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new DemFamily("Dem Data");
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new TextForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DefaultFamily.list[i] = new JAIForm();
            ++i;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Object hdf5form = null;
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> hdf5formClass = cl.loadClass("visad.data.hdf5.HDF5Form");
            hdf5form = hdf5formClass.newInstance();
            if (hdf5form != null) {
                DefaultFamily.list[i++] = hdf5form;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        FormNode junk = list[i];
        while (i < list.length) {
            DefaultFamily.list[i++] = null;
        }
        listInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFormToList(FormNode form) throws ArrayIndexOutOfBoundsException {
        FormNode[] formNodeArray = list;
        synchronized (list) {
            if (!listInitialized) {
                DefaultFamily.buildList();
            }
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != null) continue;
                System.arraycopy(list, 0, list, 1, i);
                DefaultFamily.list[0] = form;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new ArrayIndexOutOfBoundsException("Only " + list.length + " entries allowed");
        }
    }

    public DefaultFamily(String name) {
        this(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultFamily(String name, boolean netcdfText) {
        super(name);
        FormNode[] formNodeArray = list;
        synchronized (list) {
            if (!listInitialized) {
                DefaultFamily.buildList();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (netcdfText) {
                this.forms.addElement(new Plain(true));
            }
            for (int i = 0; i < list.length && list[i] != null; ++i) {
                this.forms.addElement(list[i]);
            }
            return;
        }
    }

    public static void main(String[] args) throws BadFormException, IOException, RemoteException, VisADException {
        String arg;
        int iarg;
        if (args.length < 1) {
            System.err.println("Usage: DefaultFamily [-v] infile [infile ...]");
            System.exit(1);
            return;
        }
        boolean verbose = false;
        for (iarg = 0; iarg < args.length && (arg = args[iarg]).startsWith("-"); ++iarg) {
            if (arg.equals("--")) {
                ++iarg;
                break;
            }
            if (!arg.equals("-v")) continue;
            verbose = true;
        }
        DefaultFamily fr = new DefaultFamily("sample");
        while (iarg < args.length) {
            String arg2 = args[iarg];
            System.out.println("Trying dataset " + args[iarg]);
            DataImpl data = fr.open(args[iarg]);
            if (verbose) {
                System.out.println(args[iarg] + ":\n" + data);
            } else {
                System.out.println(args[iarg] + ": " + data.getType().prettyString());
            }
            ++iarg;
        }
    }
}

