/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.lang.reflect.Method;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3f;

public class UniverseBuilderJ3D {
    private Canvas3D canvas;
    private VirtualUniverse universe;
    private Locale locale;
    TransformGroup vpTrans;
    View view;
    private BranchGroup vpRoot;
    private ViewPlatform vp;
    private static final Method REMOVE_ALL_LOCALES;
    private static final Method REMOVE_ALL_CANVAS3DS;
    private static final Class[] NIL_CLASS_ARRAY;

    public UniverseBuilderJ3D(Canvas3D c) {
        this.canvas = c;
        this.universe = new VirtualUniverse();
        this.locale = new Locale(this.universe);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(c);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.vpRoot = new BranchGroup();
        this.vpRoot.setCapability(17);
        this.vpRoot.setCapability(12);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.0f, 2.0f));
        this.vp = new ViewPlatform();
        this.vpTrans = new TransformGroup(t);
        this.vpTrans.setCapability(12);
        this.vpTrans.setCapability(17);
        this.vpTrans.setCapability(18);
        this.vpTrans.addChild((Node)this.vp);
        this.vpRoot.addChild((Node)this.vpTrans);
        this.view.attachViewPlatform(this.vp);
        this.locale.addBranchGraph(this.vpRoot);
    }

    public void addBranchGraph(BranchGroup bg) {
        if (this.locale != null) {
            this.locale.addBranchGraph(bg);
        }
    }

    public void destroy() {
        this.view.removeCanvas3D(this.canvas);
        if (REMOVE_ALL_CANVAS3DS != null) {
            try {
                REMOVE_ALL_CANVAS3DS.invoke((Object)this.view, (Object[])NIL_CLASS_ARRAY);
            }
            catch (Exception ex) {
                throw new RuntimeException("Assertion failure", ex);
            }
        }
        if (REMOVE_ALL_LOCALES != null) {
            try {
                REMOVE_ALL_LOCALES.invoke((Object)this.universe, (Object[])NIL_CLASS_ARRAY);
            }
            catch (Exception ex) {
                throw new RuntimeException("Assertion failure", ex);
            }
        }
        this.canvas = null;
        this.universe = null;
        this.locale = null;
        this.vpTrans = null;
        this.view = null;
        this.vpRoot = null;
        this.vp = null;
    }

    static {
        NIL_CLASS_ARRAY = new Class[0];
        Method method = null;
        try {
            method = Class.forName("javax.media.j3d.VirtualUniverse").getMethod("removeAllLocales", NIL_CLASS_ARRAY);
        }
        catch (Exception ex) {
            // empty catch block
        }
        REMOVE_ALL_LOCALES = method;
        method = null;
        try {
            method = Class.forName("javax.media.j3d.View").getMethod("removeAllCanvas3Ds", NIL_CLASS_ARRAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        REMOVE_ALL_CANVAS3DS = method;
    }
}

