/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.TreeMap;
import visad.DateTime;
import visad.FunctionType;
import visad.RealType;
import visad.VisADException;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceImpl;
import visad.meteorology.SingleBandedImage;

public class ImageSequenceManager {
    private ImageSequence sequence = null;
    private TreeMap imageMap = new TreeMap();

    public ImageSequenceManager() throws VisADException, RemoteException {
        this(new SingleBandedImage[0]);
    }

    public ImageSequenceManager(SingleBandedImage[] images) throws VisADException, RemoteException {
        for (int i = 0; i < images.length; ++i) {
            this.imageMap.put(images[i].getStartTime(), images[i]);
        }
        this.makeNewSequence();
    }

    public static ImageSequence createImageSequence(SingleBandedImage[] images) throws VisADException, RemoteException {
        return new ImageSequenceImpl(images);
    }

    public ImageSequence addImageToSequence(SingleBandedImage image) throws VisADException, RemoteException {
        return this.addImagesToSequence(new SingleBandedImage[]{image});
    }

    public ImageSequence addImagesToSequence(SingleBandedImage[] images) throws VisADException, RemoteException {
        for (int i = 0; i < images.length; ++i) {
            this.imageMap.put(images[i].getStartTime(), images[i]);
        }
        this.makeNewSequence();
        return this.sequence;
    }

    public ImageSequence removeImageAtTime(DateTime time) throws VisADException {
        if (time == null) {
            throw new VisADException("Time can't be null");
        }
        try {
            this.imageMap.remove(time);
            this.makeNewSequence();
        }
        catch (Exception excp) {
            throw new VisADException("Unable to remove image at " + time + " from sequence");
        }
        return this.sequence;
    }

    public void clearSequence() {
        this.imageMap.clear();
        this.sequence = null;
    }

    public void setImageSequence(ImageSequence newSequence) throws VisADException, RemoteException {
        if (newSequence == null) {
            throw new VisADException("New sequence can't be null");
        }
        this.clearSequence();
        int numImages = newSequence.getDomainSet().getLength();
        for (int i = 0; i < numImages; ++i) {
            SingleBandedImage image = (SingleBandedImage)newSequence.getSample(i);
            this.imageMap.put(image.getStartTime(), image);
        }
        this.sequence = newSequence;
    }

    public ImageSequence getImageSequence() {
        return this.sequence;
    }

    private void makeNewSequence() throws VisADException, RemoteException {
        if (this.imageMap.isEmpty()) {
            this.sequence = null;
        } else {
            Collection imageSet = this.imageMap.values();
            SingleBandedImage[] images = imageSet.toArray(new SingleBandedImage[imageSet.size()]);
            FunctionType imageFunction = (FunctionType)images[0].getType();
            FunctionType ftype = new FunctionType(RealType.Time, imageFunction);
            this.sequence = new ImageSequenceImpl(ftype, images);
        }
    }
}

