/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import visad.Data;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;
import visad.meteorology.SingleBandedImage;
import visad.util.DataUtility;

public class SingleBandedImageImpl
extends FlatField
implements SingleBandedImage {
    private DateTime startTime;
    private String description;
    private Real minValue;
    private Real maxValue;
    private boolean copyOnClone = true;

    public SingleBandedImageImpl(FunctionType function, Set domain, DateTime startTime, String desc) throws VisADException {
        this(new FlatField(function, domain), startTime, desc);
    }

    public SingleBandedImageImpl(FlatField image, DateTime startTime, String desc) throws VisADException {
        this(image, startTime, desc, true);
    }

    public SingleBandedImageImpl(FlatField image, DateTime startTime, String desc, boolean copyData) throws VisADException {
        super((FunctionType)image.getType(), image.getDomainSet(), image.getRangeCoordinateSystem()[0], image.getRangeSets(), DataUtility.getRangeUnits(image));
        if (((FunctionType)this.getType()).getFlatRange().getNumberOfRealComponents() > 1) {
            throw new VisADException("SingleBandedImageImpl: Range must be a RealType or RealTupleType with one component");
        }
        try {
            if (!image.isMissing()) {
                this.setSamples(image.getFloats(false), copyData);
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        this.startTime = startTime;
        this.description = desc;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Real getMinRangeValue() {
        this.checkMaxMinValues();
        return this.minValue;
    }

    public Real getMaxRangeValue() {
        this.checkMaxMinValues();
        return this.maxValue;
    }

    public boolean isNavigated() {
        return this.getDomainCoordinateSystem() instanceof NavigatedCoordinateSystem;
    }

    public void setSamples(float[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        super.setSamples(range, errors, copy);
        this.maxValue = null;
        this.minValue = null;
    }

    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        super.setSamples(range, errors, copy);
        this.maxValue = null;
        this.minValue = null;
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        return new SingleBandedImageImpl((FlatField)super.unary(op, new_type, sampling_mode, error_mode), this.startTime, this.description, false);
    }

    private void checkMaxMinValues() {
        if (this.minValue == null) {
            try {
                this.setMaxMinValues();
            }
            catch (Exception exc) {
                System.err.println("error:" + exc);
                exc.printStackTrace();
            }
        }
    }

    private void setMaxMinValues() throws VisADException {
        Unit units = null;
        RealType type = RealType.Generic;
        ErrorEstimate errors = null;
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        try {
            Set rangeSet = this.getRangeSets()[0];
            units = this.getRangeUnits()[0][0];
            type = (RealType)((SetType)rangeSet.getType()).getDomain().getComponent(0);
            errors = this.getRangeErrors()[0];
            if (rangeSet instanceof SampledSet) {
                min = ((SampledSet)rangeSet).getLow()[0];
                max = ((SampledSet)rangeSet).getHi()[0];
            } else {
                float[] values = this.getFloats(false)[0];
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    float value = values[i];
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.minValue = new Real(type, (double)min, units, errors);
        this.maxValue = new Real(type, (double)max, units, errors);
    }

    public Data binary(Data data, int op, int samplingMode, int errorMode) throws VisADException, RemoteException {
        Data result = super.binary(data, op, samplingMode, errorMode);
        if (data instanceof SingleBandedImage && result instanceof FlatField) {
            String desc;
            SingleBandedImage that = (SingleBandedImage)data;
            double time1 = this.startTime.getReal().getValue();
            double time2 = that.getStartTime().getReal().getValue();
            DateTime time = new DateTime((time1 + time2) / 2.0);
            String desc1 = this.description;
            String desc2 = that.getDescription();
            if (desc1.indexOf(32) != -1) {
                desc1 = "(" + desc1 + ")";
            }
            if (desc2.indexOf(32) != -1) {
                desc2 = "(" + desc2 + ")";
            }
            switch (op) {
                case 1: {
                    desc = desc1 + " + " + desc2;
                    break;
                }
                case 2: {
                    desc = desc1 + " - " + desc2;
                    break;
                }
                case 4: {
                    desc = desc1 + " * " + desc2;
                    break;
                }
                case 5: {
                    desc = desc1 + " / " + desc2;
                    break;
                }
                case 7: {
                    desc = "POW(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                case 9: {
                    desc = "MAX(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                case 10: {
                    desc = "MIN(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                case 26: {
                    desc = "ATAN2(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                case 12: {
                    desc = "ATAN2_DEGREES(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                case 15: {
                    desc = "REMAINDER(" + desc1 + ", " + desc2 + ")";
                    break;
                }
                default: {
                    throw new Error("Assertion Failure");
                }
            }
            try {
                result = new SingleBandedImageImpl((FlatField)result, time, desc, false);
            }
            catch (VisADException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public Data unary(int op, int samplingMode, int errorMode) throws VisADException, RemoteException {
        Data result = super.unary(op, samplingMode, errorMode);
        if (result instanceof FlatField) {
            String desc = this.description;
            switch (op) {
                case 21: {
                    desc = "ABS(" + desc + ")";
                    break;
                }
                case 22: {
                    desc = "ACOS(" + desc + ")";
                    break;
                }
                case 23: {
                    desc = "ACOS_DEGREES(" + desc + ")";
                    break;
                }
                case 24: {
                    desc = "ASIN(" + desc + ")";
                    break;
                }
                case 25: {
                    desc = "ASIN_DEGREES(" + desc + ")";
                    break;
                }
                case 26: {
                    desc = "ATAN(" + desc + ")";
                    break;
                }
                case 27: {
                    desc = "ATAN_DEGREES(" + desc + ")";
                    break;
                }
                case 28: {
                    desc = "CEIL(" + desc + ")";
                    break;
                }
                case 29: {
                    desc = "COS(" + desc + ")";
                    break;
                }
                case 30: {
                    desc = "COS_DEGREES(" + desc + ")";
                    break;
                }
                case 31: {
                    desc = "EXP(" + desc + ")";
                    break;
                }
                case 32: {
                    desc = "FLOOR(" + desc + ")";
                    break;
                }
                case 33: {
                    desc = "LOG(" + desc + ")";
                    break;
                }
                case 34: {
                    desc = "RINT(" + desc + ")";
                    break;
                }
                case 35: {
                    desc = "ROUND(" + desc + ")";
                    break;
                }
                case 36: {
                    desc = "SIN(" + desc + ")";
                    break;
                }
                case 37: {
                    desc = "SIN_DEGREES(" + desc + ")";
                    break;
                }
                case 38: {
                    desc = "SQRT(" + desc + ")";
                    break;
                }
                case 39: {
                    desc = "TAN(" + desc + ")";
                    break;
                }
                case 40: {
                    desc = "TAN_DEGREES(" + desc + ")";
                    break;
                }
                case 41: {
                    desc = "NEGATE(" + desc + ")";
                    break;
                }
                default: {
                    throw new Error("Assertion Failure");
                }
            }
            try {
                result = new SingleBandedImageImpl((FlatField)result, this.startTime, desc, false);
            }
            catch (VisADException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

