/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.bounce.CardPanel;
import org.bounce.QDialog;
import org.bounce.preferences.PreferencesPage;
import org.bounce.preferences.PreferencesPageCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreferencesDialog
extends QDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = -7403432397234000652L;
    private JTree tree = null;
    private CardPanel<PreferencesPage> cards = null;
    private JButton cancelButton = null;
    private JButton okButton = null;
    private JScrollPane scrollPane = null;
    private DefaultMutableTreeNode root = null;
    private DefaultTreeModel model = null;

    public PreferencesDialog(Frame parent, String title) {
        super(parent, title, true);
        this.root = new DefaultMutableTreeNode(title);
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new PreferencesPageCellRenderer());
        this.tree.setFont(this.tree.getFont().deriveFont(11.0f));
        this.tree.addTreeSelectionListener(this);
        this.scrollPane = new JScrollPane(this.tree, 20, 30);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PreferencesDialog.this.scrollPane.doLayout();
            }
        };
        this.scrollPane.getViewport().addComponentListener(resizeListener);
        this.scrollPane.setPreferredSize(new Dimension(160, 100));
        this.cards = this.getCards();
        JPanel main = this.createCenterPanel();
        main.add((Component)this.scrollPane, "West");
        main.add(this.cards, "Center");
        main.add((Component)this.createSouthPanel(), "South");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)main, "Center");
        this.setContentPane(contentPane);
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.getOkButton());
        buttonPanel.add(this.getCancelButton());
        return buttonPanel;
    }

    protected JPanel createSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        southPanel.add((Component)this.createButtonPanel(), "East");
        return southPanel;
    }

    protected CardPanel<PreferencesPage> getCards() {
        if (this.cards == null) {
            this.cards = new CardPanel();
        }
        return this.cards;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferencesDialog.this.close();
                }
            });
            this.getRootPane().setDefaultButton(this.okButton);
        }
        return this.okButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferencesDialog.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    private DefaultMutableTreeNode getParent(DefaultMutableTreeNode node2, PreferencesPage parent) {
        for (int i = 0; i < node2.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node2.getChildAt(i);
            if (child.getUserObject() == parent) {
                return child;
            }
            this.getParent(child, parent);
        }
        return null;
    }

    public void add(PreferencesPage parent, PreferencesPage page) {
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(page);
        if (parent == null) {
            this.model.insertNodeInto(node2, this.root, this.root.getChildCount());
        } else {
            DefaultMutableTreeNode parentNode = this.getParent(this.root, parent);
            this.model.insertNodeInto(node2, parentNode, parentNode.getChildCount());
        }
        this.cards.add(page);
        if (this.root.getChildCount() == 1 && node2.getLevel() == 1) {
            this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)this.model.getRoot()).getPath()));
            this.tree.setSelectionPath(new TreePath(node2.getPath()));
            this.cards.show(page);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        String title = ((PreferencesPage)node2.getUserObject()).getTitle();
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node2.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            title = parent.getUserObject() instanceof PreferencesPage ? ((PreferencesPage)parent.getUserObject()).getTitle() + " - " + title : parent.getUserObject().toString() + " - " + title;
        }
        this.setTitle(title);
        this.cards.show((PreferencesPage)node2.getUserObject());
    }
}

