/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.viewer.xml;

import java.util.List;
import org.bounce.viewer.xml.Line;
import org.bounce.viewer.xml.StyledElement;
import org.bounce.viewer.xml.StyledString;
import org.bounce.xml.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerUtils {
    private static final int MAX_LINE_LENGTH = 80;
    public static final String SHOW_ATTRIBUTES = "org.bounce.viewer.xml.showAttributes";
    public static final String SHOW_NAMESPACES = "org.bounce.viewer.xml.showNamespaces";
    public static final String SHOW_VALUES = "org.bounce.viewer.xml.showValues";
    public static final String SHOW_COMMENTS = "org.bounce.viewer.xml.showComments";

    static Line scanComment(List<Line> lines, Line current, Comment comment) {
        StyledElement styledElement = new StyledElement();
        styledElement.addString(StyledString.COMMENT_START);
        current.addStyledElement(styledElement);
        current = ScannerUtils.scanContent(lines, current, comment);
        styledElement = new StyledElement();
        styledElement.addString(StyledString.COMMENT_END);
        current.addStyledElement(styledElement);
        return current;
    }

    static Line scanEndTag(List<Line> lines, Line current, Element elem) {
        String prefix;
        StyledElement styledEnd = new StyledElement();
        styledEnd.addString(StyledString.OPEN_BRACKET);
        styledEnd.addString(StyledString.SLASH);
        if (ScannerUtils.showNamespaces() && (prefix = elem.getPrefix()) != null && prefix.length() > 0) {
            styledEnd.addString(new StyledString.ElementPrefix(prefix));
            styledEnd.addString(StyledString.ELEMENT_COLON);
        }
        styledEnd.addString(new StyledString.ElementName(DOMUtils.getName(elem)));
        styledEnd.addString(StyledString.CLOSE_BRACKET);
        current.addStyledElement(styledEnd);
        return current;
    }

    static Line scanElement(List<Line> lines, Line current, Element elem) {
        if (DOMUtils.isMixed(elem)) {
            current = ScannerUtils.scanMixedElement(lines, current, elem);
            if (ScannerUtils.showValues()) {
                current = ScannerUtils.scanEndTag(lines, current, elem);
            }
        } else {
            current = ScannerUtils.scanStartTag(lines, current, elem);
            if (ScannerUtils.showValues() && DOMUtils.hasContent(elem)) {
                current = ScannerUtils.scanContent(lines, current, elem);
                if (DOMUtils.isTextOnly(elem)) {
                    current = ScannerUtils.scanEndTag(lines, current, elem);
                }
            }
        }
        return current;
    }

    private static Line scanMixedElement(List<Line> lines, Line current, Element elem) {
        current = ScannerUtils.scanStartTag(lines, current, elem);
        if (ScannerUtils.showValues()) {
            NodeList nodes = elem.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node2 = nodes.item(i);
                if (node2 instanceof Element) {
                    current = ScannerUtils.scanMixedElement(lines, current, (Element)node2);
                    current = ScannerUtils.scanEndTag(lines, current, (Element)node2);
                    continue;
                }
                if (node2 instanceof Text) {
                    current = ScannerUtils.scanContent(lines, current, node2);
                    continue;
                }
                if (!(node2 instanceof Comment) || !ScannerUtils.showComments()) continue;
                current = ScannerUtils.scanComment(lines, current, (Comment)node2);
            }
        }
        return current;
    }

    private static Line scanStartTag(List<Line> lines, Line current, Element elem) {
        String prefix;
        StyledElement styledElement = new StyledElement();
        styledElement.addString(StyledString.OPEN_BRACKET);
        if (ScannerUtils.showNamespaces() && (prefix = elem.getPrefix()) != null && prefix.length() > 0) {
            styledElement.addString(new StyledString.ElementPrefix(prefix));
            styledElement.addString(StyledString.ELEMENT_COLON);
        }
        styledElement.addString(new StyledString.ElementName(DOMUtils.getName(elem)));
        current.addStyledElement(styledElement);
        NamedNodeMap attributes = elem.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String prefix2 = attribute.getPrefix();
            StyledElement sa = null;
            sa = prefix2 != null && prefix2.length() > 0 && "xmlns".equals(prefix2) ? ScannerUtils.formatNamespace(attribute) : ((prefix2 == null || prefix2.length() == 0) && "xmlns".equals(DOMUtils.getName(attribute)) && elem.getNamespaceURI() != null ? ScannerUtils.formatNamespace(attribute) : ScannerUtils.formatAttribute(attribute));
            if (sa == null) continue;
            if (current.length() + sa.length() + 1 > 80) {
                current = new Line();
                lines.add(current);
                current.addStyledString(StyledString.TAB);
            } else {
                current.addStyledString(StyledString.SPACE);
            }
            current.addStyledElement(sa);
        }
        if (!DOMUtils.hasContent(elem)) {
            current.addStyledString(StyledString.SLASH);
        } else if (DOMUtils.isTextOnly(elem) && !ScannerUtils.showValues()) {
            current.addStyledString(StyledString.SLASH);
        }
        current.addStyledString(StyledString.CLOSE_BRACKET);
        return current;
    }

    private static Line scanContent(List<Line> lines, Line current, Node node2) {
        String text = null;
        if (node2 instanceof CharacterData) {
            text = ((CharacterData)node2).getData();
        } else if (node2 instanceof Element) {
            text = DOMUtils.getText((Element)node2);
        }
        if (current.length() + 1 >= 80 && text.length() > 0) {
            current = new Line();
            lines.add(current);
            current.addStyledString(StyledString.TAB);
        }
        if (text.length() > 0) {
            boolean parsed = false;
            while (!parsed) {
                int length = 80 - (current.length() + 1);
                if (length > text.length()) {
                    int index = text.indexOf("\n");
                    if (index == -1) {
                        index = text.indexOf("\r");
                    }
                    if (index == -1) {
                        index = text.length();
                    }
                    if (index != 0) {
                        if (node2 instanceof Element || node2 instanceof Text) {
                            current.addStyledString(new StyledString.ElementValue(text.substring(0, index)));
                        } else if (node2 instanceof Comment) {
                            current.addStyledString(new StyledString.CommentText(text.substring(0, index)));
                        }
                    }
                    if (index == text.length()) {
                        parsed = true;
                    } else {
                        text = text.substring(index + 1, text.length());
                    }
                } else {
                    String sub = text.substring(0, length);
                    int index = sub.indexOf("\n");
                    if (index == -1) {
                        index = sub.indexOf("\r");
                    }
                    if (index == -1) {
                        index = sub.lastIndexOf(" ");
                    }
                    if (index > 0) {
                        if (node2 instanceof Element || node2 instanceof Text) {
                            current.addStyledString(new StyledString.ElementValue(sub.substring(0, index)));
                        } else if (node2 instanceof Comment) {
                            current.addStyledString(new StyledString.CommentText(sub.substring(0, index)));
                        }
                        text = text.substring(index + 1, text.length());
                    } else {
                        int nlindex = text.indexOf("\n");
                        int rindex = text.indexOf("\r");
                        int spindex = sub.indexOf(" ");
                        if (nlindex == -1) {
                            nlindex = Integer.MAX_VALUE;
                        }
                        if (rindex == -1) {
                            rindex = Integer.MAX_VALUE;
                        }
                        if (spindex == -1) {
                            spindex = Integer.MAX_VALUE;
                        }
                        index = Math.min(nlindex, rindex);
                        index = Math.min(index, spindex);
                        index = Math.min(index, text.length());
                        if (node2 instanceof Element || node2 instanceof Text) {
                            current.addStyledString(new StyledString.ElementValue(text.substring(0, index)));
                        } else if (node2 instanceof Comment) {
                            current.addStyledString(new StyledString.CommentText(text.substring(0, index)));
                        }
                        if (index == text.length()) {
                            parsed = true;
                        } else {
                            text = text.substring(index + 1, text.length());
                        }
                    }
                }
                if (parsed) continue;
                current = new Line();
                lines.add(current);
                current.addStyledString(StyledString.TAB);
            }
        }
        return current;
    }

    private static StyledElement formatAttribute(Attr a) {
        StyledElement styledAttribute = null;
        if (ScannerUtils.showAttributes()) {
            styledAttribute = new StyledElement();
            String prefix = a.getPrefix();
            if (ScannerUtils.showNamespaces() && prefix != null && prefix.length() > 0) {
                styledAttribute.addString(new StyledString.AttributePrefix(prefix));
                styledAttribute.addString(StyledString.ATTRIBUTE_COLON);
            }
            styledAttribute.addString(new StyledString.AttributeName(DOMUtils.getName(a)));
            styledAttribute.addString(StyledString.ATTRIBUTE_ASIGN);
            styledAttribute.addString(new StyledString.AttributeValue(a.getValue()));
        }
        return styledAttribute;
    }

    private static StyledElement formatNamespace(Attr a) {
        StyledElement styledNamespace = null;
        if (ScannerUtils.showNamespaces()) {
            styledNamespace = new StyledElement();
            String prefix = a.getPrefix();
            styledNamespace.addString(StyledString.NAMESPACE_NAME);
            if (prefix != null && prefix.length() > 0) {
                styledNamespace.addString(StyledString.NAMESPACE_COLON);
                styledNamespace.addString(new StyledString.NamespacePrefix(DOMUtils.getName(a)));
            }
            styledNamespace.addString(StyledString.NAMESPACE_ASIGN);
            styledNamespace.addString(new StyledString.NamespaceURI(a.getValue()));
        }
        return styledNamespace;
    }

    public static boolean showNamespaces() {
        return System.getProperty(SHOW_NAMESPACES, String.valueOf(true)).equals(String.valueOf(true));
    }

    public static boolean showValues() {
        return System.getProperty(SHOW_VALUES, String.valueOf(true)).equals(String.valueOf(true));
    }

    public static boolean showAttributes() {
        return System.getProperty(SHOW_ATTRIBUTES, String.valueOf(true)).equals(String.valueOf(true));
    }

    public static boolean showComments() {
        return System.getProperty(SHOW_COMMENTS, String.valueOf(true)).equals(String.valueOf(true));
    }
}

