/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.builder;

import java.util.Collections;
import java.util.List;
import thredds.catalog2.builder.BuilderIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderException
extends Exception {
    private final List<BuilderIssue> issues;

    public BuilderException(BuilderIssue issue) {
        this.issues = Collections.singletonList(issue);
    }

    public BuilderException(List<BuilderIssue> issues) {
        this.issues = issues;
    }

    public BuilderException(BuilderIssue issue, Throwable cause) {
        super(cause);
        this.issues = Collections.singletonList(issue);
    }

    public BuilderException(List<BuilderIssue> issues, Throwable cause) {
        super(cause);
        this.issues = issues;
    }

    public List<BuilderIssue> getSources() {
        return Collections.unmodifiableList(this.issues);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (BuilderIssue bfi : this.issues) {
            sb.append(bfi.getMessage()).append("\n");
        }
        return sb.toString();
    }
}

