/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.catalog.ServiceType;
import thredds.catalog2.Access;
import thredds.catalog2.Dataset;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.simpleImpl.AccessImpl;
import thredds.catalog2.simpleImpl.CatalogImpl;
import thredds.catalog2.simpleImpl.DatasetNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetImpl
extends DatasetNodeImpl
implements Dataset,
DatasetBuilder {
    private List<AccessImpl> accessImplList;
    private boolean isBuilt = false;

    protected DatasetImpl(String name, CatalogImpl parentCatalog, DatasetNodeImpl parent) {
        super(name, parentCatalog, parent);
    }

    @Override
    public AccessBuilder addAccessBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetBuilder has been built.");
        }
        AccessImpl a = new AccessImpl(this);
        if (this.accessImplList == null) {
            this.accessImplList = new ArrayList<AccessImpl>();
        }
        this.accessImplList.add(a);
        return a;
    }

    @Override
    public boolean removeAccessBuilder(AccessBuilder accessBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetBuilder has been built.");
        }
        if (this.accessImplList == null) {
            return false;
        }
        return this.accessImplList.remove(accessBuilder);
    }

    @Override
    public boolean isAccessible() {
        if (this.accessImplList == null) {
            return false;
        }
        return !this.accessImplList.isEmpty();
    }

    @Override
    public List<Access> getAccesses() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Dataset has escaped its DatasetBuilder before build() was called.");
        }
        if (this.accessImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<AccessImpl>(this.accessImplList));
    }

    @Override
    public List<Access> getAccessesByType(ServiceType type) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Dataset has escaped its DatasetBuilder before build() was called.");
        }
        ArrayList<Access> list = new ArrayList<Access>();
        if (this.accessImplList != null) {
            for (AccessImpl a : this.accessImplList) {
                if (!a.getService().getType().equals(type)) continue;
                list.add(a);
            }
        }
        return list;
    }

    @Override
    public List<AccessBuilder> getAccessBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetBuilder has been built.");
        }
        if (this.accessImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<AccessImpl>(this.accessImplList));
    }

    @Override
    public List<AccessBuilder> getAccessBuildersByType(ServiceType type) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetBuilder has been built.");
        }
        ArrayList<AccessBuilder> list = new ArrayList<AccessBuilder>();
        if (this.accessImplList != null) {
            for (AccessImpl a : this.accessImplList) {
                if (!a.getServiceBuilder().getType().equals(type)) continue;
                list.add(a);
            }
        }
        return list;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        ArrayList<BuilderIssue> localIssues = new ArrayList<BuilderIssue>();
        super.isBuildable(issues);
        if (this.accessImplList != null) {
            for (AccessImpl ab : this.accessImplList) {
                ab.isBuildable(localIssues);
            }
        }
        if (localIssues.isEmpty()) {
            return true;
        }
        issues.addAll(localIssues);
        return false;
    }

    @Override
    public Dataset build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        super.build();
        if (this.accessImplList != null) {
            for (AccessImpl ab : this.accessImplList) {
                ab.build();
            }
        }
        this.isBuilt = true;
        return this;
    }
}

