/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Property;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.simpleImpl.PropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyContainer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Property> propertiesMap = null;
    private boolean isBuilt = false;

    PropertyContainer() {
    }

    public boolean isEmpty() {
        if (this.propertiesMap == null) {
            return true;
        }
        return this.propertiesMap.isEmpty();
    }

    public int size() {
        if (this.propertiesMap == null) {
            return 0;
        }
        return this.propertiesMap.size();
    }

    public void addProperty(String name, String value) {
        PropertyImpl property;
        if (this.isBuilt) {
            throw new IllegalStateException("This PropertyContainer has been built.");
        }
        if (this.propertiesMap == null) {
            this.propertiesMap = new LinkedHashMap<String, Property>();
        }
        if (null != this.propertiesMap.put(name, property = new PropertyImpl(name, value)) && this.log.isDebugEnabled()) {
            this.log.debug("addProperty(): reseting property [" + name + "].");
        }
    }

    public boolean removeProperty(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This PropertyContainer has been built.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Given name may not be null.");
        }
        if (this.propertiesMap == null) {
            return false;
        }
        Property property = this.propertiesMap.remove(name);
        return property != null;
    }

    public List<String> getPropertyNames() {
        if (this.propertiesMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<String>(this.propertiesMap.keySet()));
    }

    public boolean containsPropertyName(String name) {
        if (name == null) {
            return false;
        }
        if (this.propertiesMap == null) {
            return false;
        }
        return this.propertiesMap.get(name) != null;
    }

    public String getPropertyValue(String name) {
        if (name == null) {
            return null;
        }
        if (this.propertiesMap == null) {
            return null;
        }
        Property property = this.propertiesMap.get(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public List<Property> getProperties() {
        if (this.propertiesMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Property>(this.propertiesMap.values()));
    }

    public Property getPropertyByName(String name) {
        if (name == null) {
            return null;
        }
        if (this.propertiesMap == null) {
            return null;
        }
        return this.propertiesMap.get(name);
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public boolean isBuildable(List<BuilderIssue> issues) {
        return true;
    }

    public void build() {
        this.isBuilt = true;
    }
}

