/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.ServiceType;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.PropertyContainer;
import thredds.catalog2.simpleImpl.ServiceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
implements Service,
ServiceBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String description;
    private ServiceType type;
    private URI baseUri;
    private String suffix;
    private PropertyContainer propertyContainer;
    private ServiceContainer serviceContainer;
    private boolean isBuilt = false;

    protected ServiceImpl(String name, ServiceType type, URI baseUri, ServiceContainer rootContainer) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Service type must not be null.");
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI must not be null.");
        }
        this.name = name;
        this.description = "";
        this.type = type;
        this.baseUri = baseUri;
        this.suffix = "";
        this.propertyContainer = new PropertyContainer();
        this.serviceContainer = new ServiceContainer(rootContainer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.description = description != null ? description : "";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setType(ServiceType type) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Service type must not be null.");
        }
        this.type = type;
    }

    @Override
    public ServiceType getType() {
        return this.type;
    }

    @Override
    public void setBaseUri(URI baseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI must not be null.");
        }
        this.baseUri = baseUri;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public void setSuffix(String suffix) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.suffix = suffix != null ? suffix : "";
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void addProperty(String name, String value) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.propertyContainer.addProperty(name, value);
    }

    @Override
    public boolean removeProperty(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.removeProperty(name);
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.getPropertyValue(name);
    }

    @Override
    public List<Property> getProperties() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder before build() was called.");
        }
        return this.propertyContainer.getProperties();
    }

    @Override
    public Property getPropertyByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder before build() was called.");
        }
        return this.propertyContainer.getPropertyByName(name);
    }

    @Override
    public boolean isServiceNameInUseGlobally(String name) {
        return this.serviceContainer.isServiceNameInUseGlobally(name);
    }

    @Override
    public ServiceBuilder addService(String name, ServiceType type, URI baseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        if (this.isServiceNameInUseGlobally(name)) {
            throw new IllegalStateException("Given service name [" + name + "] not unique in catalog.");
        }
        ServiceImpl sb = new ServiceImpl(name, type, baseUri, this.serviceContainer.getRootServiceContainer());
        this.serviceContainer.addService(sb);
        return sb;
    }

    @Override
    public ServiceBuilder removeService(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        if (name == null) {
            return null;
        }
        ServiceImpl removedService = this.serviceContainer.removeService(name);
        if (null == removedService) {
            this.log.debug("removeService(): unknown ServiceBuilder [" + name + "] (not in map).");
            return null;
        }
        return removedService;
    }

    @Override
    public List<Service> getServices() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being built.");
        }
        return this.serviceContainer.getServices();
    }

    @Override
    public Service getServiceByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being built.");
        }
        return this.serviceContainer.getServiceByName(name);
    }

    @Override
    public Service findServiceByNameGlobally(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped its Builder before being built.");
        }
        return this.serviceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public List<ServiceBuilder> getServiceBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilders();
    }

    @Override
    public ServiceBuilder getServiceBuilderByName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilderByName(name);
    }

    @Override
    public ServiceBuilder findServiceBuilderByNameGlobally(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.serviceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        ArrayList<BuilderIssue> localIssues = new ArrayList<BuilderIssue>();
        this.propertyContainer.isBuildable(localIssues);
        this.serviceContainer.isBuildable(localIssues);
        if (this.serviceContainer.isEmpty() && this.baseUri == null) {
            localIssues.add(new BuilderIssue("Non-compound services must have base URI.", this));
        }
        if (localIssues.isEmpty()) {
            return true;
        }
        issues.addAll(localIssues);
        return false;
    }

    @Override
    public Service build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        this.propertyContainer.build();
        this.serviceContainer.build();
        this.isBuilt = true;
        return this;
    }
}

