/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.catalog.DataFormatType;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreddsMetadataImpl
implements ThreddsMetadata,
ThreddsMetadataBuilder {
    private boolean isBuilt = false;
    private List<DocumentationImpl> docs;
    private List<KeyphraseImpl> keyphrases;
    private List<ContributorImpl> creators;
    private List<ContributorImpl> contributors;
    private List<ContributorImpl> publishers;
    private String projectTitle;
    private DateType dateCreated;
    private DateType dateModified;
    private DateType dateIssued;
    private DateRange dateValid;
    private DateRange dateAvailable;
    private DateType dateMetadataCreated;
    private DateType dateMetadataModified;
    private GeospatialCoverageImpl geospatialCoverage;
    private DateRange temporalCoverage;
    private List<VariableImpl> variables;
    private long dataSizeInBytes;
    private DataFormatType dataFormat;
    private FeatureType dataType;
    private String collectionType;

    @Override
    public ThreddsMetadataBuilder.DocumentationBuilder addDocumentation(String docType, String title, URI externalReference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title may not be null.");
        }
        if (externalReference == null) {
            throw new IllegalArgumentException("External reference may not be null.");
        }
        if (this.docs == null) {
            this.docs = new ArrayList<DocumentationImpl>();
        }
        DocumentationImpl doc = new DocumentationImpl(docType, title, externalReference);
        this.docs.add(doc);
        return doc;
    }

    @Override
    public ThreddsMetadataBuilder.DocumentationBuilder addDocumentation(String docType, String content) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null.");
        }
        if (this.docs == null) {
            this.docs = new ArrayList<DocumentationImpl>();
        }
        DocumentationImpl doc = new DocumentationImpl(docType, content);
        this.docs.add(doc);
        return doc;
    }

    @Override
    public boolean removeDocumentation(ThreddsMetadataBuilder.DocumentationBuilder docBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (docBuilder == null) {
            return false;
        }
        if (this.docs == null) {
            return false;
        }
        return this.docs.remove((DocumentationImpl)docBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.DocumentationBuilder> getDocumentationBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DocumentationImpl>(this.docs));
    }

    @Override
    public List<ThreddsMetadata.Documentation> getDocumentation() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DocumentationImpl>(this.docs));
    }

    @Override
    public ThreddsMetadataBuilder.KeyphraseBuilder addKeyphrase(String authority, String phrase) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (phrase == null) {
            throw new IllegalArgumentException("Phrase may not be null.");
        }
        if (this.keyphrases == null) {
            this.keyphrases = new ArrayList<KeyphraseImpl>();
        }
        KeyphraseImpl keyphrase = new KeyphraseImpl();
        keyphrase.setAuthority(authority);
        keyphrase.setPhrase(phrase);
        this.keyphrases.add(keyphrase);
        return keyphrase;
    }

    @Override
    public boolean removeKeyphrase(ThreddsMetadataBuilder.KeyphraseBuilder keyphraseBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (keyphraseBuilder == null) {
            return false;
        }
        if (this.keyphrases == null) {
            return false;
        }
        return this.keyphrases.remove((KeyphraseImpl)keyphraseBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.KeyphraseBuilder> getKeyphraseBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.keyphrases == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<KeyphraseImpl>(this.keyphrases));
    }

    @Override
    public List<ThreddsMetadata.Keyphrase> getKeyphrases() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.keyphrases == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<KeyphraseImpl>(this.keyphrases));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addCreator() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.creators == null) {
            this.creators = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.creators.add(contributor);
        return contributor;
    }

    @Override
    public boolean removeCreator(ThreddsMetadataBuilder.ContributorBuilder creatorBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (creatorBuilder == null) {
            return false;
        }
        if (this.creators == null) {
            return false;
        }
        return this.creators.remove((ContributorImpl)creatorBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getCreatorBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.creators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.creators));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getCreator() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.creators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.creators));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addContributor() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.contributors == null) {
            this.contributors = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.contributors.add(contributor);
        return contributor;
    }

    @Override
    public boolean removeContributor(ThreddsMetadataBuilder.ContributorBuilder contributorBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (contributorBuilder == null) {
            return false;
        }
        if (this.contributors == null) {
            return false;
        }
        return this.contributors.remove((ContributorImpl)contributorBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getContributorBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.contributors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.contributors));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getContributor() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.contributors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.contributors));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addPublisher() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.publishers == null) {
            this.publishers = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.publishers.add(contributor);
        return contributor;
    }

    @Override
    public boolean removePublisher(ThreddsMetadataBuilder.ContributorBuilder publisherBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (publisherBuilder == null) {
            return false;
        }
        if (this.publishers == null) {
            return false;
        }
        return this.publishers.remove((ContributorImpl)publisherBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getPublisherBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.publishers));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getPublisher() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.publishers));
    }

    @Override
    public void setProjectTitle(String projectTitle) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.projectTitle = projectTitle;
    }

    @Override
    public String getProjectTitle() {
        return this.projectTitle;
    }

    @Override
    public void setDateCreated(DateType dateCreated) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateCreated = dateCreated;
    }

    @Override
    public DateType getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateModified(DateType dateModified) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateModified = dateModified;
    }

    @Override
    public DateType getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateIssued(DateType dateIssued) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateIssued = dateIssued;
    }

    @Override
    public DateType getDateIssued() {
        return this.dateIssued;
    }

    @Override
    public void setDateValid(DateRange dateValid) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateValid = dateValid;
    }

    @Override
    public DateRange getDateValid() {
        return this.dateValid;
    }

    @Override
    public void setDateAvailable(DateRange dateAvailable) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateAvailable = dateAvailable;
    }

    @Override
    public DateRange getDateAvailable() {
        return this.dateAvailable;
    }

    @Override
    public void setDateMetadataCreated(DateType dateMetadataCreated) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateMetadataCreated = dateMetadataCreated;
    }

    @Override
    public DateType getDateMetadataCreated() {
        return this.dateMetadataCreated;
    }

    @Override
    public void setDateMetadataModified(DateType dateMetadataModified) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dateMetadataModified = dateMetadataModified;
    }

    @Override
    public DateType getDateMetadataModified() {
        return this.dateMetadataModified;
    }

    @Override
    public ThreddsMetadataBuilder.GeospatialCoverageBuilder setNewGeospatialCoverageBuilder(URI crsUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        GeospatialCoverageImpl gci = new GeospatialCoverageImpl();
        gci.setCRS(crsUri);
        this.geospatialCoverage = gci;
        return null;
    }

    @Override
    public void removeGeospatialCoverageBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.geospatialCoverage = null;
    }

    @Override
    public ThreddsMetadataBuilder.GeospatialCoverageBuilder getGeospatialCoverageBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.geospatialCoverage;
    }

    @Override
    public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.geospatialCoverage;
    }

    @Override
    public void setTemporalCoverage(DateRange temporalCoverage) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.temporalCoverage = temporalCoverage;
    }

    @Override
    public DateRange getTemporalCoverage() {
        return this.temporalCoverage;
    }

    @Override
    public ThreddsMetadataBuilder.VariableBuilder addVariableBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.variables == null) {
            this.variables = new ArrayList<VariableImpl>();
        }
        VariableImpl var = new VariableImpl();
        this.variables.add(var);
        return var;
    }

    @Override
    public boolean removeVariableBuilder(ThreddsMetadataBuilder.VariableBuilder variableBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (variableBuilder == null) {
            return false;
        }
        if (this.variables == null) {
            return false;
        }
        return this.variables.remove((VariableImpl)variableBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.VariableBuilder> getVariableBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.variables == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<VariableImpl>(this.variables));
    }

    @Override
    public List<ThreddsMetadata.Variable> getVariables() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.variables == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<VariableImpl>(this.variables));
    }

    @Override
    public void setDataSizeInBytes(long dataSizeInBytes) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataSizeInBytes = dataSizeInBytes;
    }

    @Override
    public long getDataSizeInBytes() {
        return this.dataSizeInBytes;
    }

    @Override
    public void setDataFormat(DataFormatType dataFormat) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataFormat = dataFormat;
    }

    @Override
    public void setDataFormat(String dataFormat) {
        this.setDataFormat(DataFormatType.getType(dataFormat));
    }

    @Override
    public DataFormatType getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void setDataType(FeatureType dataType) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataType = dataType;
    }

    @Override
    public FeatureType getDataType() {
        return this.dataType;
    }

    @Override
    public void setCollectionType(String collectionType) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.collectionType = collectionType;
    }

    @Override
    public String getCollectionType() {
        return this.collectionType;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        ArrayList<BuilderIssue> localIssues = new ArrayList<BuilderIssue>();
        if (this.docs != null) {
            for (DocumentationImpl doc : this.docs) {
                doc.isBuildable(localIssues);
            }
        }
        if (localIssues.isEmpty()) {
            return true;
        }
        issues.addAll(localIssues);
        return false;
    }

    @Override
    public ThreddsMetadata build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        if (this.docs != null) {
            for (DocumentationImpl doc : this.docs) {
                doc.build();
            }
        }
        this.isBuilt = true;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeospatialRangeImpl
    implements ThreddsMetadata.GeospatialRange,
    ThreddsMetadataBuilder.GeospatialRangeBuilder {
        private boolean isBuilt = false;
        private boolean isHorizontal = false;
        private double start = 0.0;
        private double size = 0.0;
        private double resolution = 0.0;
        private String units = "";

        @Override
        public void setHorizontal(boolean isHorizontal) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isHorizontal = isHorizontal;
        }

        @Override
        public boolean isHorizontal() {
            return this.isHorizontal;
        }

        @Override
        public void setStart(double start) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.start = start;
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public void setSize(double size) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.size = size;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public void setResolution(double resolution) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.resolution = resolution;
        }

        @Override
        public double getResolution() {
            return this.resolution;
        }

        @Override
        public void setUnits(String units) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.units = units == null ? "" : units;
        }

        @Override
        public String getUnits() {
            return this.units;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return true;
        }

        @Override
        public ThreddsMetadata.GeospatialRange build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeospatialCoverageImpl
    implements ThreddsMetadata.GeospatialCoverage,
    ThreddsMetadataBuilder.GeospatialCoverageBuilder {
        private boolean isBuilt = false;
        private URI defaultCrsUri;
        private URI crsUri;
        private boolean is3D;
        private boolean isZPositiveUp;
        private boolean isGlobal;
        private List<GeospatialRangeImpl> extent;

        GeospatialCoverageImpl() {
            String defaultCrsUriString = "urn:x-mycrs:2D-WGS84-ellipsoid";
            try {
                this.defaultCrsUri = new URI(defaultCrsUriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Bad URI syntax for default CRS URI [" + defaultCrsUriString + "]: " + e.getMessage());
            }
            this.crsUri = this.defaultCrsUri;
        }

        @Override
        public void setCRS(URI crsUri) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (crsUri == null) {
                this.crsUri = this.defaultCrsUri;
            }
            this.crsUri = crsUri;
        }

        @Override
        public URI getCRS() {
            return this.crsUri;
        }

        @Override
        public void setGlobal(boolean isGlobal) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isGlobal = isGlobal;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        @Override
        public void setZPositiveUp(boolean isZPositiveUp) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isZPositiveUp = isZPositiveUp;
        }

        @Override
        public boolean isZPositiveUp() {
            return this.isZPositiveUp;
        }

        @Override
        public ThreddsMetadataBuilder.GeospatialRangeBuilder addExtentBuilder() {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (this.extent == null) {
                this.extent = new ArrayList<GeospatialRangeImpl>();
            }
            GeospatialRangeImpl gri = new GeospatialRangeImpl();
            this.extent.add(gri);
            return gri;
        }

        @Override
        public boolean removeExtentBuilder(ThreddsMetadataBuilder.GeospatialRangeBuilder geospatialRangeBuilder) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (geospatialRangeBuilder == null) {
                return true;
            }
            if (this.extent == null) {
                return false;
            }
            return this.extent.remove((GeospatialRangeImpl)geospatialRangeBuilder);
        }

        @Override
        public List<ThreddsMetadataBuilder.GeospatialRangeBuilder> getExtentBuilders() {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (this.extent == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<GeospatialRangeImpl>(this.extent));
        }

        @Override
        public List<ThreddsMetadata.GeospatialRange> getExtent() {
            if (!this.isBuilt) {
                throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
            }
            if (this.extent == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<GeospatialRangeImpl>(this.extent));
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return false;
        }

        @Override
        public ThreddsMetadata.GeospatialCoverage build() throws BuilderException {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableImpl
    implements ThreddsMetadata.Variable,
    ThreddsMetadataBuilder.VariableBuilder {
        private boolean isBuilt;
        private String authority = "";
        private String id;
        private String title = "";
        private String description = "";
        private String units = "";

        @Override
        public String getAuthority() {
            return this.authority;
        }

        @Override
        public void setAuthority(String authority) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.authority = authority == null ? "" : authority;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (id == null) {
                throw new IllegalArgumentException("Id may not be null.");
            }
            this.id = id;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setTitle(String title) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.title = title == null ? "" : title;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String description) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.description = description == null ? "" : description;
        }

        @Override
        public String getUnits() {
            return this.units;
        }

        @Override
        public void setUnits(String units) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.units = units == null ? "" : units;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return true;
        }

        @Override
        public ThreddsMetadata.Variable build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContributorImpl
    implements ThreddsMetadata.Contributor,
    ThreddsMetadataBuilder.ContributorBuilder {
        private boolean isBuilt;
        private String authority;
        private String name;
        private String email;
        private URI webPage;

        @Override
        public String getAuthority() {
            return this.authority;
        }

        @Override
        public void setAuthority(String authority) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.authority = authority;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name may not be null.");
            }
            this.name = name;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public void setEmail(String email) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.email = email;
        }

        @Override
        public URI getWebPage() {
            return this.webPage;
        }

        @Override
        public void setWebPage(URI webPage) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.webPage = webPage;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return true;
        }

        @Override
        public ThreddsMetadata.Contributor build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyphraseImpl
    implements ThreddsMetadata.Keyphrase,
    ThreddsMetadataBuilder.KeyphraseBuilder {
        private boolean isBuilt;
        private String authority;
        private String phrase;

        @Override
        public void setAuthority(String authority) {
        }

        @Override
        public String getAuthority() {
            return null;
        }

        @Override
        public void setPhrase(String phrase) {
        }

        @Override
        public String getPhrase() {
            return null;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return false;
        }

        @Override
        public ThreddsMetadata.Keyphrase build() throws BuilderException {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocumentationImpl
    implements ThreddsMetadata.Documentation,
    ThreddsMetadataBuilder.DocumentationBuilder {
        private final boolean isContainedContent;
        public final String docType;
        public final String title;
        public final URI externalReference;
        public final String content;

        public DocumentationImpl(String docType, String title, URI externalReference) {
            if (title == null) {
                throw new IllegalArgumentException("Title may not be null.");
            }
            if (externalReference == null) {
                throw new IllegalArgumentException("External reference may not be null.");
            }
            this.isContainedContent = false;
            this.docType = docType;
            this.title = title;
            this.externalReference = externalReference;
            this.content = null;
        }

        public DocumentationImpl(String docType, String content) {
            if (content == null) {
                throw new IllegalArgumentException("Content may not be null.");
            }
            this.isContainedContent = true;
            this.docType = docType;
            this.title = null;
            this.externalReference = null;
            this.content = content;
        }

        @Override
        public boolean isContainedContent() {
            return this.isContainedContent;
        }

        @Override
        public String getDocType() {
            return this.docType;
        }

        @Override
        public String getContent() {
            if (!this.isContainedContent) {
                throw new IllegalStateException("No contained content, use externally reference to access documentation content.");
            }
            return this.content;
        }

        @Override
        public String getTitle() {
            if (this.isContainedContent) {
                throw new IllegalStateException("Documentation with contained content has no title.");
            }
            return this.title;
        }

        @Override
        public URI getExternalReference() {
            if (this.isContainedContent) {
                throw new IllegalStateException("Documentation with contained content has no external reference.");
            }
            return this.externalReference;
        }

        @Override
        public boolean isBuilt() {
            return true;
        }

        @Override
        public boolean isBuildable(List<BuilderIssue> issues) {
            return true;
        }

        @Override
        public ThreddsMetadata.Documentation build() throws BuilderException {
            return this;
        }
    }
}

