/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.sax;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import thredds.catalog2.Catalog;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.xml.names.CatalogNamespace;
import thredds.catalog2.xml.parser.ThreddsXmlParser;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.sax.ThreddsCatalogHandler;

public class SAXCatalogParser
implements ThreddsXmlParser {
    private static Logger log = LoggerFactory.getLogger(SAXCatalogParser.class);
    private boolean isValidating = false;
    private Schema schema = null;

    private SAXCatalogParser() {
    }

    public static SAXCatalogParser getInstance() {
        return new SAXCatalogParser();
    }

    public boolean wantValidating(boolean wantValidating) {
        if (wantValidating && this.schema == null) {
            try {
                this.schema = CatalogNamespace.CATALOG_1_0.getSchema();
            }
            catch (IOException e) {
                log.warn("wantValidating(): Failed to read schema.", e);
                this.schema = null;
            }
            catch (SAXException e) {
                log.warn("wantValidating(): Failed to parse schema.", e);
                this.schema = null;
            }
            this.isValidating = this.schema != null;
        } else if (wantValidating && this.schema != null) {
            this.isValidating = true;
        } else if (!wantValidating) {
            this.isValidating = false;
        }
        return this.isValidating;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    private Catalog readXML(InputSource source) throws ThreddsXmlParserException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        if (this.isValidating) {
            factory.setSchema(this.schema);
        }
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        ThreddsCatalogHandler catHandler = new ThreddsCatalogHandler(source.getSystemId());
        try {
            parser.parse(source, (DefaultHandler)catHandler);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return catHandler.getCatalog();
        }
        catch (BuilderException e) {
            throw new ThreddsXmlParserException("Catalog builder in bad state.", e);
        }
    }

    public Catalog parse(URI uri) throws ThreddsXmlParserException {
        InputSource is = new InputSource(uri.toString());
        return this.readXML(is);
    }

    public Catalog parse(File file, URI baseUri) throws ThreddsXmlParserException {
        InputSource is = null;
        try {
            is = new InputSource(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        is.setSystemId(baseUri.toString());
        return this.readXML(is);
    }

    public Catalog parse(Reader reader, URI baseUri) throws ThreddsXmlParserException {
        InputSource is = new InputSource(reader);
        is.setSystemId(baseUri.toString());
        return this.readXML(is);
    }

    public Catalog parse(InputStream is, URI baseUri) throws ThreddsXmlParserException {
        InputSource inSource = new InputSource(is);
        inSource.setSystemId(baseUri.toString());
        return this.readXML(inSource);
    }

    public CatalogBuilder parseIntoBuilder(URI uri) throws ThreddsXmlParserException {
        return null;
    }

    public CatalogBuilder parseIntoBuilder(File file, URI baseUri) throws ThreddsXmlParserException {
        return null;
    }

    public CatalogBuilder parseIntoBuilder(Reader reader, URI baseUri) throws ThreddsXmlParserException {
        return null;
    }

    public CatalogBuilder parseIntoBuilder(InputStream is, URI baseUri) throws ThreddsXmlParserException {
        return null;
    }
}

