/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.sax;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import thredds.catalog2.Catalog;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.xml.parser.sax.CatalogHandler;
import thredds.catalog2.xml.parser.sax.ServiceHandler;

public class ThreddsCatalogHandler
extends DefaultHandler {
    private Logger logger = LoggerFactory.getLogger(ThreddsCatalogHandler.class);
    private CatalogBuilder builder;
    private String docSystemId;
    private DefaultHandler state;
    private ErrorHandler errorHandler;
    private Map<String, String> namespaceMap;

    public ThreddsCatalogHandler(String docSystemId) {
        if (docSystemId == null) {
            throw new IllegalArgumentException("Document system ID must not be null.");
        }
        this.docSystemId = docSystemId;
        this.state = null;
        this.namespaceMap = new HashMap<String, String>();
    }

    Catalog getCatalog() throws BuilderException {
        if (this.builder != null) {
            return this.builder.build();
        }
        return null;
    }

    void setState(DefaultHandler state) {
        this.state = state;
    }

    void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMap.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceMap.remove(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.state != null) {
            this.state.startElement(uri, localName, qName, attributes);
        }
        if (localName.equals("catalog")) {
            this.state = new CatalogHandler(this.docSystemId, attributes, this, this);
        }
        if (localName.equals("service")) {
            this.state = new ServiceHandler(null, null, attributes, this, this);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.state != null) {
            this.state.endElement(uri, localName, qName);
        }
        throw new SAXException("Closing XML element [" + localName + "] after parsing completed.");
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errorHandler.warning(e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorHandler.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errorHandler.fatalError(e);
    }
}

