/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.names.AccessElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class AccessElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatasetBuilder datasetBuilder;

    public AccessElementParser(XMLEventReader reader, DatasetBuilder datasetBuilder) throws ThreddsXmlParserException {
        super(reader, AccessElementNames.AccessElement);
        this.datasetBuilder = datasetBuilder;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return AccessElementParser.isSelfElement(event, AccessElementNames.AccessElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return AccessElementParser.isSelfElement(event, AccessElementNames.AccessElement);
    }

    protected AccessBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        AccessBuilder builder = null;
        if (this.datasetBuilder == null) {
            throw new ThreddsXmlParserException("");
        }
        builder = this.datasetBuilder.addAccessBuilder();
        Attribute serviceNameAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_ServiceName);
        String serviceName = serviceNameAtt.getValue();
        ServiceBuilder serviceBuilder = this.datasetBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(serviceName);
        Attribute urlPathAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_UrlPath);
        String urlPath = urlPathAtt.getValue();
        builder.setServiceBuilder(serviceBuilder);
        builder.setUrlPath(urlPath);
        Attribute dataFormatAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_DataFormat);
        if (dataFormatAtt != null) {
            builder.setDataFormat(DataFormatType.getType(dataFormatAtt.getValue()));
        }
        return builder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

