/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.CatalogElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.ServiceElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class CatalogElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String docBaseUriString;
    private final ThreddsBuilderFactory catBuilderFactory;

    public CatalogElementParser(String docBaseUriString, XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory) throws ThreddsXmlParserException {
        super(reader, CatalogElementNames.CatalogElement);
        this.docBaseUriString = docBaseUriString;
        this.catBuilderFactory = catBuilderFactory;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return CatalogElementParser.isSelfElement(event, CatalogElementNames.CatalogElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return CatalogElementParser.isSelfElement(event, CatalogElementNames.CatalogElement);
    }

    protected CatalogBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Name);
        String nameString = nameAtt != null ? nameAtt.getValue() : null;
        Attribute versionAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Version);
        String versionString = versionAtt != null ? versionAtt.getValue() : null;
        Attribute expiresAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Expires);
        Date expiresDate = null;
        Attribute lastModifiedAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_LastModified);
        Date lastModifiedDate = null;
        URI docBaseUri = null;
        try {
            docBaseUri = new URI(this.docBaseUriString);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad catalog base URI [" + this.docBaseUriString + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad catalog base URI [" + this.docBaseUriString + "]: " + e.getMessage(), e);
        }
        return this.catBuilderFactory.newCatalogBuilder(nameString, docBaseUri, versionString, expiresDate, lastModifiedDate);
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof CatalogBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of CatalogBuilder.");
        }
        CatalogBuilder catalogBuilder = (CatalogBuilder)builder;
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (ServiceElementParser.isSelfElementStatic(startElement)) {
            ServiceElementParser serviceElemParser = new ServiceElementParser(this.reader, catalogBuilder);
            serviceElemParser.parse();
        } else if (PropertyElementParser.isSelfElementStatic(startElement)) {
            PropertyElementParser parser = new PropertyElementParser(this.reader, catalogBuilder);
            parser.parse();
        } else if (DatasetElementParser.isSelfElementStatic(startElement)) {
            DatasetElementParser parser = new DatasetElementParser(this.reader, catalogBuilder, null);
            parser.parse();
        } else {
            StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }

    public static class Factory {
    }
}

