/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.CatalogRefElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class CatalogRefElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final ThreddsBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserHelper datasetNodeElementParserHelper;

    public CatalogRefElementParser(XMLEventReader reader, CatalogBuilder catBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, CatalogRefElementNames.CatalogRefElement);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    public CatalogRefElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, CatalogRefElementNames.CatalogRefElement);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    public CatalogRefElementParser(XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, CatalogRefElementNames.CatalogRefElement);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return CatalogRefElementParser.isSelfElement(event, CatalogRefElementNames.CatalogRefElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return CatalogRefElementParser.isSelfElement(event, CatalogRefElementNames.CatalogRefElement);
    }

    protected DatasetNodeBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute titleAtt = startElement.getAttributeByName(CatalogRefElementNames.CatalogRefElement_XlinkTitle);
        String title = titleAtt.getValue();
        Attribute hrefAtt = startElement.getAttributeByName(CatalogRefElementNames.CatalogRefElement_XlinkHref);
        String href = hrefAtt.getValue();
        URI hrefUri = null;
        try {
            hrefUri = new URI(href);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
        }
        CatalogRefBuilder catalogRefBuilder = null;
        if (this.catBuilder != null) {
            catalogRefBuilder = this.catBuilder.addCatalogRef(title, hrefUri);
        } else if (this.datasetNodeBuilder != null) {
            catalogRefBuilder = this.datasetNodeBuilder.addCatalogRef(title, hrefUri);
        } else if (this.catBuilderFactory != null) {
            catalogRefBuilder = this.catBuilderFactory.newCatalogRefBuilder(title, hrefUri);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserHelper.parseStartElementIdAttribute(startElement, catalogRefBuilder);
        this.datasetNodeElementParserHelper.parseStartElementIdAuthorityAttribute(startElement, catalogRefBuilder);
        return catalogRefBuilder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof CatalogRefBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.datasetNodeElementParserHelper.handleBasicChildStartElement(startElement, this.reader, (CatalogRefBuilder)builder)) {
            return;
        }
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

