/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.DatasetElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.AccessElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class DatasetElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String docBaseUriString;
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final ThreddsBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserHelper datasetNodeElementParserHelper;

    public DatasetElementParser(XMLEventReader reader, CatalogBuilder catBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, DatasetElementNames.DatasetElement);
        this.docBaseUriString = null;
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    public DatasetElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, DatasetElementNames.DatasetElement);
        this.docBaseUriString = null;
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    public DatasetElementParser(XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, DatasetElementNames.DatasetElement);
        this.docBaseUriString = null;
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(parentDatasetNodeElementParserHelper);
    }

    public DatasetElementParser(String docBaseUriString, XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory) throws ThreddsXmlParserException {
        super(reader, DatasetElementNames.DatasetElement);
        this.docBaseUriString = docBaseUriString;
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(null);
    }

    protected void setDefaultServiceName(String defaultServiceName) {
        this.datasetNodeElementParserHelper.setDefaultServiceName(defaultServiceName);
    }

    protected String getDefaultServiceName() {
        return this.datasetNodeElementParserHelper.getDefaultServiceName();
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return DatasetElementParser.isSelfElement(event, DatasetElementNames.DatasetElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return DatasetElementParser.isSelfElement(event, DatasetElementNames.DatasetElement);
    }

    protected DatasetBuilder parseStartElement() throws ThreddsXmlParserException {
        Attribute urlPathAtt;
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_Name);
        String name = nameAtt.getValue();
        DatasetBuilder datasetBuilder = null;
        if (this.catBuilder != null) {
            datasetBuilder = this.catBuilder.addDataset(name);
        } else if (this.datasetNodeBuilder != null) {
            datasetBuilder = this.datasetNodeBuilder.addDataset(name);
        } else if (this.catBuilderFactory != null) {
            datasetBuilder = this.catBuilderFactory.newDatasetBuilder(name);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserHelper.parseStartElementIdAttribute(startElement, datasetBuilder);
        this.datasetNodeElementParserHelper.parseStartElementIdAuthorityAttribute(startElement, datasetBuilder);
        Attribute serviceNameAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_ServiceName);
        if (serviceNameAtt != null) {
            this.setDefaultServiceName(serviceNameAtt.getValue());
        }
        if ((urlPathAtt = startElement.getAttributeByName(DatasetElementNames.DatasetElement_UrlPath)) != null) {
            AccessBuilder accessBuilder = datasetBuilder.addAccessBuilder();
            accessBuilder.setUrlPath(urlPathAtt.getValue());
        }
        return datasetBuilder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof DatasetBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        DatasetBuilder datasetBuilder = (DatasetBuilder)builder;
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.datasetNodeElementParserHelper.handleBasicChildStartElement(startElement, this.reader, datasetBuilder)) {
            return;
        }
        if (this.datasetNodeElementParserHelper.handleCollectionChildStartElement(startElement, this.reader, datasetBuilder)) {
            return;
        }
        if (AccessElementParser.isSelfElementStatic(startElement)) {
            AccessElementParser parser = new AccessElementParser(this.reader, datasetBuilder);
            parser.parse();
            return;
        }
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof DatasetBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        DatasetBuilder datasetBuilder = (DatasetBuilder)builder;
        this.datasetNodeElementParserHelper.postProcessing(builder);
        if (this.getDefaultServiceName() != null && !datasetBuilder.getAccessBuilders().isEmpty()) {
            ServiceBuilder defaultServiceBuilder = datasetBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(this.getDefaultServiceName());
            for (AccessBuilder curAB : datasetBuilder.getAccessBuilders()) {
                if (curAB.getServiceBuilder() != null) continue;
                curAB.setServiceBuilder(defaultServiceBuilder);
            }
        }
    }
}

