/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.simpleImpl.ThreddsBuilderFactoryImpl;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.CatalogElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class DocumentParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    ThreddsBuilder parseMetadataIntoBuilder(XMLEventReader reader, String docBaseUri) throws ThreddsXmlParserException {
        try {
            ThreddsBuilderFactoryImpl catBuilderFac = new ThreddsBuilderFactoryImpl();
            CatalogBuilder catBuilder = null;
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if (event.isEndDocument()) {
                    reader.next();
                    continue;
                }
                if (event.isStartDocument()) {
                    reader.next();
                    continue;
                }
                if (event.isStartElement()) {
                    if (CatalogElementParser.isSelfElementStatic(event.asStartElement())) {
                        CatalogElementParser catElemParser = new CatalogElementParser(docBaseUri, reader, catBuilderFac);
                        catBuilder = (CatalogBuilder)catElemParser.parse();
                        continue;
                    }
                    StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(reader);
                    this.log.warn("readCatalogXML(): Unrecognized start element [" + event.asStartElement().getName() + "].");
                    reader.next();
                    continue;
                }
                if (event.isEndElement()) {
                    if (CatalogElementParser.isSelfElementStatic(event.asEndElement())) break;
                    this.log.error("readCatalogXML(): Unrecognized end element [" + event.asEndElement().getName() + "].");
                    break;
                }
                this.log.debug("readCatalogXML(): Unhandled event [" + event.getLocation() + "--" + event + "].");
                reader.next();
            }
            reader.close();
            if (catBuilder == null) {
                return null;
            }
            return catBuilder;
        }
        catch (XMLStreamException e) {
            this.log.error("readCatalogXML(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }
}

