/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.MetadataElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.parser.stax.ThreddsMetadataElementParser;

public class MetadataElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatasetNodeBuilder datasetBuilder;
    private final ThreddsBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserHelper datasetNodeElementParserHelper;
    private boolean isMetadataElementInherited;
    private StringBuilder content = null;

    public MetadataElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserHelper datasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, MetadataElementNames.MetadataElement);
        this.datasetBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserHelper = datasetNodeElementParserHelper;
        this.isMetadataElementInherited = false;
    }

    public MetadataElementParser(XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory, DatasetNodeElementParserHelper datasetNodeElementParserHelper) throws ThreddsXmlParserException {
        super(reader, MetadataElementNames.MetadataElement);
        this.datasetBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserHelper = datasetNodeElementParserHelper;
        this.isMetadataElementInherited = false;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return MetadataElementParser.isSelfElement(event, MetadataElementNames.MetadataElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return MetadataElementParser.isSelfElement(event, MetadataElementNames.MetadataElement);
    }

    public boolean doesMetadataElementGetInherited() {
        return this.isMetadataElementInherited;
    }

    protected MetadataBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        MetadataBuilder builder = null;
        if (this.datasetBuilder != null) {
            builder = this.datasetBuilder.addMetadata();
        } else if (this.catBuilderFactory != null) {
            builder = this.catBuilderFactory.newMetadataBuilder();
        } else {
            throw new ThreddsXmlParserException("");
        }
        Attribute inheritedAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_Inherited);
        if (inheritedAtt != null && inheritedAtt.getValue().equalsIgnoreCase("true")) {
            this.isMetadataElementInherited = true;
        }
        Attribute titleAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_XlinkTitle);
        Attribute externalRefAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_XlinkHref);
        if (titleAtt == null && externalRefAtt == null) {
            builder.setContainedContent(true);
            return builder;
        }
        if (titleAtt == null || externalRefAtt == null) {
            throw new ThreddsXmlParserException("MetadataBuilder with link has a null title or link URL ");
        }
        String title = titleAtt.getValue();
        String uriString = externalRefAtt.getValue();
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ThreddsXmlParserException("MetadataBuilder with link has link with bad URI syntax.", e);
        }
        builder.setContainedContent(false);
        builder.setTitle(title);
        builder.setExternalReference(uri);
        return builder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof DatasetNodeBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetNodeBuilder.");
        }
        DatasetNodeBuilder dsNodeBuilder = (DatasetNodeBuilder)builder;
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (ThreddsMetadataElementParser.isSelfElementStatic(startElement)) {
            ThreddsMetadataElementParser parser = new ThreddsMetadataElementParser(this.reader, this.datasetBuilder, this.datasetNodeElementParserHelper, this.isMetadataElementInherited);
            parser.parse();
        } else {
            if (this.content == null) {
                this.content = new StringBuilder();
            }
            this.content.append(StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader));
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof MetadataBuilder)) {
            throw new IllegalArgumentException("Builder must be a MetadataBuilder.");
        }
        MetadataBuilder mdBldr = (MetadataBuilder)builder;
        if (this.content != null) {
            mdBldr.setContent(this.content.toString());
        }
    }
}

