/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.names.PropertyElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class PropertyElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final ServiceBuilder serviceBuilder;

    public boolean isChildElement(XMLEvent event) {
        return false;
    }

    public PropertyElementParser(XMLEventReader reader, CatalogBuilder catBuilder) throws ThreddsXmlParserException {
        super(reader, PropertyElementNames.PropertyElement);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = null;
    }

    public PropertyElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder) throws ThreddsXmlParserException {
        super(reader, PropertyElementNames.PropertyElement);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.serviceBuilder = null;
    }

    public PropertyElementParser(XMLEventReader reader, ServiceBuilder serviceBuilder) throws ThreddsXmlParserException {
        super(reader, PropertyElementNames.PropertyElement);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = serviceBuilder;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return PropertyElementParser.isSelfElement(event, PropertyElementNames.PropertyElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return PropertyElementParser.isSelfElement(event, PropertyElementNames.PropertyElement);
    }

    protected ThreddsBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(PropertyElementNames.PropertyElement_Name);
        String name = nameAtt.getValue();
        Attribute valueAtt = startElement.getAttributeByName(PropertyElementNames.PropertyElement_Value);
        String value = valueAtt.getValue();
        if (this.catBuilder != null) {
            this.catBuilder.addProperty(name, value);
        } else if (this.datasetNodeBuilder != null) {
            this.datasetNodeBuilder.addProperty(name, value);
        } else if (this.serviceBuilder != null) {
            this.serviceBuilder.addProperty(name, value);
        } else {
            throw new ThreddsXmlParserException("Unknown builder - for addProperty().");
        }
        return null;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (!this.isChildElement(startElement)) {
            StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

