/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.ServiceType;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.ServiceElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class ServiceElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final CatalogBuilder catBuilder;
    private final ServiceBuilder serviceBuilder;
    private final ThreddsBuilderFactory catBuilderFactory;

    public ServiceElementParser(XMLEventReader reader, CatalogBuilder catBuilder) throws ThreddsXmlParserException {
        super(reader, ServiceElementNames.ServiceElement);
        this.catBuilder = catBuilder;
        this.serviceBuilder = null;
        this.catBuilderFactory = null;
    }

    public ServiceElementParser(XMLEventReader reader, ServiceBuilder serviceBuilder) throws ThreddsXmlParserException {
        super(reader, ServiceElementNames.ServiceElement);
        this.catBuilder = null;
        this.serviceBuilder = serviceBuilder;
        this.catBuilderFactory = null;
    }

    public ServiceElementParser(XMLEventReader reader, ThreddsBuilderFactory catBuilderFactory) throws ThreddsXmlParserException {
        super(reader, ServiceElementNames.ServiceElement);
        this.catBuilder = null;
        this.serviceBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return ServiceElementParser.isSelfElement(event, ServiceElementNames.ServiceElement);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return ServiceElementParser.isSelfElement(event, ServiceElementNames.ServiceElement);
    }

    protected ServiceBuilder parseStartElement() throws ThreddsXmlParserException {
        Attribute descriptionAtt;
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Name);
        String name = nameAtt.getValue();
        Attribute serviceTypeAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_ServiceType);
        ServiceType serviceType = ServiceType.getType(serviceTypeAtt.getValue());
        Attribute baseUriAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Base);
        String baseUriString = baseUriAtt.getValue();
        URI baseUri = null;
        try {
            baseUri = new URI(baseUriString);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad service base URI [" + baseUriString + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad service base URI [" + baseUriString + "]", e);
        }
        ServiceBuilder serviceBuilder = null;
        if (this.catBuilder != null) {
            serviceBuilder = this.catBuilder.addService(name, serviceType, baseUri);
        } else if (this.serviceBuilder != null) {
            serviceBuilder = this.serviceBuilder.addService(name, serviceType, baseUri);
        } else if (this.catBuilderFactory != null) {
            serviceBuilder = this.catBuilderFactory.newServiceBuilder(name, serviceType, baseUri);
        } else {
            throw new ThreddsXmlParserException("");
        }
        Attribute suffixAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Suffix);
        if (suffixAtt != null) {
            serviceBuilder.setSuffix(suffixAtt.getValue());
        }
        if ((descriptionAtt = startElement.getAttributeByName(ServiceElementNames.ServiceElement_Description)) != null) {
            serviceBuilder.setSuffix(descriptionAtt.getValue());
        }
        return serviceBuilder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof ServiceBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        ServiceBuilder serviceBuilder = (ServiceBuilder)builder;
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (ServiceElementParser.isSelfElementStatic(startElement)) {
            ServiceElementParser serviceElemParser = new ServiceElementParser(this.reader, serviceBuilder);
            serviceElemParser.parse();
        } else if (PropertyElementParser.isSelfElementStatic(startElement)) {
            PropertyElementParser parser = new PropertyElementParser(this.reader, serviceBuilder);
            parser.parse();
        } else {
            StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

