/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

public class StaxThreddsXmlParserUtils {
    private static Logger log = LoggerFactory.getLogger(StaxThreddsXmlParserUtils.class);

    public static String consumeElementAndConvertToXmlString(XMLEventReader xmlEventReader) throws ThreddsXmlParserException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader may not be null.");
        }
        StringWriter writerUsingWriteAsEncodedUnicode = new StringWriter();
        StringWriter writerUsingToString = new StringWriter();
        Location startLocation = null;
        try {
            XMLEvent event = xmlEventReader.peek();
            if (!event.isStartElement()) {
                throw new IllegalArgumentException("Next event in reader must be start element.");
            }
            startLocation = event.getLocation();
            ArrayList<QName> nameList = new ArrayList<QName>();
            while (xmlEventReader.hasNext()) {
                event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    nameList.add(event.asStartElement().getName());
                } else if (event.isEndElement()) {
                    QName endElemName = event.asEndElement().getName();
                    QName lastName = (QName)nameList.get(nameList.size() - 1);
                    if (lastName.equals(endElemName)) {
                        nameList.remove(nameList.size() - 1);
                    } else {
                        String msg = "Badly formed XML? End element [" + endElemName.getLocalPart() + "] doesn't match expected start element [" + lastName.getLocalPart() + "].";
                        log.error("consumeElementAndConvertToXmlString(): " + msg);
                        throw new ThreddsXmlParserException("FATAL? " + msg);
                    }
                }
                event.writeAsEncodedUnicode(writerUsingWriteAsEncodedUnicode);
                writerUsingToString.write(event.toString());
                if (!nameList.isEmpty()) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new ThreddsXmlParserException("Problem reading unknown element [" + startLocation + "]. Underlying cause: " + e.getMessage(), e);
        }
        String result = writerUsingWriteAsEncodedUnicode.toString();
        if (result == null || result.equals("")) {
            result = writerUsingToString.toString();
        }
        return result;
    }

    public static String getCharacterContent(XMLEventReader xmlEventReader, QName containingElementName) throws ThreddsXmlParserException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader may not be null.");
        }
        if (!xmlEventReader.hasNext()) {
            throw new IllegalArgumentException("XMLEventReader must have next.");
        }
        if (containingElementName == null) {
            throw new IllegalArgumentException("Containing element name may not be null.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Location location = null;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.peek();
                location = event.getLocation();
                if (event.isCharacters()) {
                    event = xmlEventReader.nextEvent();
                    stringBuilder.append(event.asCharacters().getData());
                    continue;
                }
                if (event.isEndElement()) {
                    if (event.asEndElement().getName().equals(containingElementName)) {
                        return stringBuilder.toString();
                    }
                    throw new IllegalStateException("Badly formed XML? Unexpected end element [" + event.asEndElement().getName().getLocalPart() + "][" + location + "] doesn't match expected start element [" + containingElementName.getLocalPart() + "].");
                }
                if (event.isStartElement()) {
                    throw new IllegalStateException("Badly formed XML? Unexpected start element [" + event.asStartElement().getName().getLocalPart() + "][" + location + "] when characters expected.");
                }
                xmlEventReader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new ThreddsXmlParserException("Problem reading unknown event [" + location + "]. Underlying cause: " + e.getMessage(), e);
        }
        throw new ThreddsXmlParserException("Unexpected end of XMLEventReader.");
    }

    public static Source getSourceFromUri(URI documentUri) throws ThreddsXmlParserException {
        HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(documentUri);
        InputStream is = null;
        try {
            httpUriResolver.makeRequest();
            is = httpUriResolver.getResponseBodyAsInputStream();
        }
        catch (IOException e) {
            throw new ThreddsXmlParserException("Problem accessing resource [" + documentUri.toString() + "].", e);
        }
        return new StreamSource(is, documentUri.toString());
    }

    public static Source getSourceFromFile(File file, URI docBaseUri) throws ThreddsXmlParserException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null.");
        }
        StreamSource source = null;
        if (docBaseUri == null) {
            source = new StreamSource(file);
        } else {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                String message = "Couldn't find file [" + file.getPath() + "].";
                log.error("parseIntoBuilder(): " + message, e);
                throw new ThreddsXmlParserException(message, e);
            }
            source = new StreamSource(is, docBaseUri.toString());
        }
        return source;
    }

    public static XMLEventReader getEventReaderFromSource(Source source, XMLInputFactory factory) throws ThreddsXmlParserException {
        XMLEventReader reader;
        try {
            reader = factory.createXMLEventReader(source);
        }
        catch (XMLStreamException e) {
            String message = "Problems reading stream [" + source.getSystemId() + "].";
            log.error("getEventReaderFromSource(): " + message, e);
            throw new ThreddsXmlParserException(message, e);
        }
        return reader;
    }
}

