/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.xml.names.ThreddsMetadataElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class ThreddsMetadataElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<QName, AbstractElementParser> selfElements = new HashMap<QName, AbstractElementParser>();
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
    private final boolean inheritedByDescendants;
    private ThreddsMetadataBuilder resultThreddsMetadataBuilder;

    public ThreddsMetadataElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) throws ThreddsXmlParserException {
        super(reader, ThreddsMetadataElementNames.ThreddsMetadataElement);
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
        this.inheritedByDescendants = inheritedByDescendants;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        if (ServiceNameElementParser.isSelfElementStatic(event)) {
            return true;
        }
        return DataFormatElementParser.isSelfElementStatic(event);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return ThreddsMetadataElementParser.isSelfElementStatic(event);
    }

    protected ThreddsMetadataBuilder parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (!this.isSelfElement(startElement)) {
            throw new IllegalArgumentException("Start element [" + startElement.getName().getLocalPart() + "] must be one of the THREDDS metadata element.");
        }
        if (this.resultThreddsMetadataBuilder == null) {
            if (this.datasetNodeBuilder != null) {
                this.resultThreddsMetadataBuilder = this.datasetNodeBuilder.setNewThreddsMetadataBuilder();
            } else {
                throw new ThreddsXmlParserException("");
            }
        }
        if (ServiceNameElementParser.isSelfElementStatic(startElement)) {
            ServiceNameElementParser parser = new ServiceNameElementParser(this.reader, this.resultThreddsMetadataBuilder, this.parentDatasetNodeElementParserHelper, this.inheritedByDescendants);
            parser.parse();
        } else if (DataFormatElementParser.isSelfElementStatic(startElement)) {
            DataFormatElementParser parser = new DataFormatElementParser(this.reader, this.resultThreddsMetadataBuilder);
            parser.parse();
        } else {
            throw new ThreddsXmlParserException("");
        }
        return this.resultThreddsMetadataBuilder;
    }

    protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (ServiceNameElementParser.isSelfElementStatic(startElement)) {
            return;
        }
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }

    public static class DataFormatElementParser
    extends AbstractElementParser {
        private final ThreddsMetadataBuilder threddsMetadataBuilder;

        public DataFormatElementParser(XMLEventReader reader, ThreddsMetadataBuilder threddsMetadataBuilder) throws ThreddsXmlParserException {
            super(reader, ThreddsMetadataElementNames.DataFormatElement);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
        }

        protected static boolean isSelfElementStatic(XMLEvent event) {
            return DataFormatElementParser.isSelfElement(event, ThreddsMetadataElementNames.DataFormatElement);
        }

        protected boolean isSelfElement(XMLEvent event) {
            return DataFormatElementParser.isSelfElementStatic(event);
        }

        protected ThreddsMetadataBuilder parseStartElement() throws ThreddsXmlParserException {
            StartElement startElement = this.getNextEventIfStartElementIsMine();
            String dataFormat = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, ThreddsMetadataElementNames.DataFormatElement);
            this.threddsMetadataBuilder.setDataFormat(dataFormat);
            return null;
        }

        protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        }

        protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
        }
    }

    public static class ServiceNameElementParser
    extends AbstractElementParser {
        private Logger log = LoggerFactory.getLogger(this.getClass());
        private final ThreddsMetadataBuilder threddsMetadataBuilder;
        private DatasetNodeBuilder datasetNodeBuilder;
        private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
        private final boolean inheritedByDescendants;
        private String serviceName;

        public ServiceNameElementParser(XMLEventReader reader, ThreddsMetadataBuilder threddsMetadataBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) throws ThreddsXmlParserException {
            super(reader, ThreddsMetadataElementNames.ServiceNameElement);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
            this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
            this.inheritedByDescendants = inheritedByDescendants;
        }

        protected static boolean isSelfElementStatic(XMLEvent event) {
            return ServiceNameElementParser.isSelfElement(event, ThreddsMetadataElementNames.ServiceNameElement);
        }

        protected boolean isSelfElement(XMLEvent event) {
            return ServiceNameElementParser.isSelfElementStatic(event);
        }

        protected ThreddsMetadataBuilder parseStartElement() throws ThreddsXmlParserException {
            this.getNextEventIfStartElementIsMine();
            this.serviceName = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, ThreddsMetadataElementNames.ServiceNameElement);
            this.parentDatasetNodeElementParserHelper.setDefaultServiceName(this.serviceName);
            return null;
        }

        protected void handleChildStartElement(ThreddsBuilder builder) throws ThreddsXmlParserException {
        }

        protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
            if (this.inheritedByDescendants) {
                this.parentDatasetNodeElementParserHelper.setDefaultServiceNameThatGetsInherited(this.serviceName);
            } else {
                this.parentDatasetNodeElementParserHelper.setDefaultServiceName(this.serviceName);
            }
        }
    }
}

