/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import thredds.filesystem.CacheDirectory;

@ThreadSafe
public class CacheManagerOld {
    public boolean debug = false;
    private CacheManager cacheManager;
    private Cache cache;
    private AtomicLong addDir = new AtomicLong();
    private AtomicLong hits = new AtomicLong();
    private AtomicLong requests = new AtomicLong();

    public CacheManagerOld() {
    }

    public CacheManagerOld(String ehconfig) {
        this.cacheManager = new CacheManager(ehconfig);
        this.cache = this.cacheManager.getCache("directory");
    }

    public CacheManagerOld(InputStream ehconfig) {
        this.cacheManager = new CacheManager(ehconfig);
        this.cache = this.cacheManager.getCache("directory");
    }

    public void add(Object key, Object value) {
        if (this.cache == null) {
            return;
        }
        this.cache.put(new Element(key, value));
        this.addDir.incrementAndGet();
    }

    public CacheDirectory get(String path) {
        File p;
        CacheDirectory m;
        Element e;
        this.requests.incrementAndGet();
        if (this.cache != null && (e = this.cache.get((Serializable)((Object)path))) != null) {
            if (this.debug) {
                System.out.printf(" InCache %s%n", path);
            }
            if ((m = (CacheDirectory)e.getValue()).notModified()) {
                if (this.debug) {
                    System.out.printf(" Hit %s%n", path);
                }
                this.hits.incrementAndGet();
                return m;
            }
            this.cache.put(new Element((Serializable)((Object)path), null));
        }
        if (!(p = new File(path)).exists()) {
            return null;
        }
        if (this.debug) {
            System.out.printf(" Read file system %s%n", path);
        }
        m = new CacheDirectory(p);
        this.add(path, m);
        return m;
    }

    public void close() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
        this.cacheManager = null;
    }

    public void show() {
        for (Object o : this.cache.getKeys()) {
            System.out.printf(" %s%n", o);
        }
    }

    public void populate() {
        String root = "C:/";
        long startCount = this.addDir.get();
        long start = System.nanoTime();
        long end = System.nanoTime();
        long total = this.addDir.get() - startCount;
        System.out.printf("populate %n%-20s total %d took %d msecs %n", root, total, (end - start) / 1000L / 1000L);
    }

    public void stats() {
        System.out.printf(" dirs added= %s%n", this.addDir.get());
        System.out.printf(" reqs= %d%n", this.requests.get());
        System.out.printf(" hits= %d%n", this.hits.get());
        if (this.cache != null) {
            System.out.printf(" cache= %s%n", this.cache.toString());
            System.out.printf(" cache.size= %d%n", this.cache.getSize());
            System.out.printf(" cache.memorySize= %d%n", this.cache.getMemoryStoreSize());
            Statistics stats = this.cache.getStatistics();
            System.out.printf(" stats= %s%n", stats.toString());
        }
    }

    public static void main(String[] args) throws IOException {
        CacheManagerOld man = new CacheManagerOld("C:/dev/tds/fileManager/src/main/ehcache.xml");
        DataInputStream in = new DataInputStream(System.in);
        while (true) {
            System.out.printf("dir: ", new Object[0]);
            String line = in.readLine();
            if (line == null || line.length() == 0) break;
            if (line.equals("show")) {
                man.show();
                continue;
            }
            if (line.equals("populate")) {
                man.populate();
                continue;
            }
            long start = System.nanoTime();
            CacheDirectory dir = man.get(line);
            long end = System.nanoTime();
            System.out.printf("%n%-20s took %d usecs %n", line, (end - start) / 1000L);
            System.out.printf(" man.size=%s%n", dir.getChildren().length);
        }
        man.stats();
        man.close();
    }
}

