/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.DateExtractor;
import thredds.filesystem.MFile;
import thredds.filesystem.MFileFilter;

public class MCollection {
    private static Logger logger = LoggerFactory.getLogger(MCollection.class);
    private String name;
    private String dirName;
    private MFileFilter ff;
    private DateExtractor dateExtractor;
    private Date last = null;
    private Date first = null;

    public MCollection(String name, String dirName, MFileFilter ff, DateExtractor dateExtractor) {
        this.name = name;
        this.dirName = dirName;
        this.ff = ff;
        this.dateExtractor = dateExtractor;
    }

    public MCollection subdir(MFile child) {
        return new MCollection(this.name + "/" + child.getName(), this.dirName + "/" + child.getName(), this.ff, this.dateExtractor);
    }

    public String getName() {
        return this.name;
    }

    public String getDirectoryName() {
        return this.dirName;
    }

    public Date getLast() {
        return this.last;
    }

    public Date getFirst() {
        return this.first;
    }

    public boolean accept(MFile file) {
        Date d;
        if (this.ff != null && !this.ff.accept(file)) {
            return false;
        }
        if (null != this.dateExtractor && (d = this.dateExtractor.getDate(file)) != null) {
            if (this.last == null || d.after(this.last)) {
                this.last = d;
            }
            if (this.first == null || d.before(this.first)) {
                this.first = d;
            }
        }
        return true;
    }
}

