/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.GribPDSVariablesIF;

public class GribPDSVariables
implements GribPDSVariablesIF {
    public int productType;
    public int discipline;
    public int category;
    public int paramNumber;
    public int typeGenProcess;
    public int levelType1;
    public int levelType2;
    public float levelValue1;
    public float levelValue2;
    public int gdsKey;
    public long offset1;
    public long offset2;
    public Date refTime;
    public int forecastTime;
    public int decimalScale = -9999;
    public boolean bmsExists = true;
    public int center = -1;
    public int subCenter = -1;
    public int table = -1;
    public int numberForecasts;
    public int type = -9999;
    public float lowerLimit;
    public float upperLimit;
    private Date validTime = null;

    public GribPDSVariables() {
    }

    public GribPDSVariables(Calendar calendar, int productType, int discipline, int category, int param, int typeGenProcess, int levelType1, float levelValue1, int levelType2, float levelValue2, Date refTime, int foreTime, int gdsKey, long offset1, long offset2, int decimalScale, boolean bmsExists, int center, int subCenter, int table) {
        try {
            this.gdsKey = gdsKey;
            this.productType = productType;
            this.discipline = discipline;
            this.category = category;
            this.paramNumber = param;
            this.typeGenProcess = typeGenProcess;
            this.levelType1 = levelType1;
            this.levelValue1 = levelValue1;
            this.levelType2 = levelType2;
            this.levelValue2 = levelValue2;
            this.refTime = refTime;
            this.forecastTime = foreTime;
            calendar.setTime(refTime);
            calendar.add(10, this.forecastTime);
            this.validTime = calendar.getTime();
            this.offset1 = offset1;
            this.offset2 = offset2;
            if (decimalScale != -9999) {
                this.decimalScale = decimalScale;
                this.bmsExists = bmsExists;
            }
            this.center = center;
            this.subCenter = subCenter;
            this.table = table;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    GribPDSVariables(Calendar calendar, SimpleDateFormat dateFormat, String productTypeS, String disciplineS, String categoryS, String paramS, String typeGenProcessS, String levelType1S, String levelValue1S, String levelType2S, String levelValue2S, String refTimeS, String foreTimeS, String gdsKeyS, String offset1S, String offset2S, String decimalScaleS, String bmsExistsS, String centerS, String subCenterS, String tableS) {
        try {
            this.gdsKey = Integer.parseInt(gdsKeyS);
            this.productType = Integer.parseInt(productTypeS);
            this.discipline = Integer.parseInt(disciplineS);
            this.category = Integer.parseInt(categoryS);
            this.paramNumber = Integer.parseInt(paramS);
            this.typeGenProcess = Integer.parseInt(typeGenProcessS);
            this.levelType1 = Integer.parseInt(levelType1S);
            this.levelValue1 = Float.parseFloat(levelValue1S);
            this.levelType2 = Integer.parseInt(levelType2S);
            this.levelValue2 = Float.parseFloat(levelValue2S);
            this.refTime = dateFormat.parse(refTimeS);
            this.forecastTime = Integer.parseInt(foreTimeS);
            calendar.setTime(this.refTime);
            calendar.add(10, this.forecastTime);
            this.validTime = calendar.getTime();
            this.offset1 = Long.parseLong(offset1S);
            this.offset2 = Long.parseLong(offset2S);
            if (decimalScaleS != null) {
                this.decimalScale = Integer.parseInt(decimalScaleS);
            }
            if (bmsExistsS != null) {
                this.bmsExists = bmsExistsS.equals("true");
            }
            if (centerS != null) {
                this.center = Integer.parseInt(centerS);
            }
            if (subCenterS != null) {
                this.subCenter = Integer.parseInt(subCenterS);
            }
            if (tableS != null) {
                this.table = Integer.parseInt(tableS);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public final int getLength() {
        return -9999;
    }

    public final int getSection() {
        return -9999;
    }

    public final int getCoordinates() {
        return -9999;
    }

    public final int getProductDefinition() {
        return this.productType;
    }

    public final int getParameterCategory() {
        return this.category;
    }

    public final int getParameterNumber() {
        return this.paramNumber;
    }

    public final int getTypeGenProcess() {
        return this.typeGenProcess;
    }

    public final int getChemicalType() {
        return -9999;
    }

    public final int getBackGenProcess() {
        return -9999;
    }

    public final int getObservationProcess() {
        return -9999;
    }

    public final int getNB() {
        return -9999;
    }

    public final int getAnalysisGenProcess() {
        return -9999;
    }

    public final int getHoursAfter() {
        return -9999;
    }

    public final int getMinutesAfter() {
        return -9999;
    }

    public final int getTimeRangeUnit() {
        return -9999;
    }

    public final int getForecastTime() {
        return this.forecastTime;
    }

    public float getValueFirstFixedSurface() {
        return this.levelValue1;
    }

    public float getValueSecondFixedSurface() {
        return this.levelValue2;
    }

    public int getTypeFirstFixedSurface() {
        return this.levelType1;
    }

    public int getTypeSecondFixedSurface() {
        return this.levelType2;
    }

    public Date getReferenceTime() {
        return this.refTime;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Date t) {
        this.validTime = t;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public final int getType() {
        return -9999;
    }

    public final int getForecastProbability() {
        return -9999;
    }

    public final int getForecastPercentile() {
        return -9999;
    }

    public final int getPerturbation() {
        return -9999;
    }

    public final int getNumberForecasts() {
        return -9999;
    }

    public final float getValueLowerLimit() {
        return -9999.0f;
    }

    public final float getValueUpperLimit() {
        return -9999.0f;
    }

    public String toString() {
        return "GribGridRecord{productType=" + this.productType + ", discipline=" + this.discipline + ", category=" + this.category + ", paramNumber=" + this.paramNumber + ", typeGenProcess=" + this.typeGenProcess + ", levelType1=" + this.levelType1 + ", levelType2=" + this.levelType2 + ", levelValue1=" + this.levelValue1 + ", levelValue2=" + this.levelValue2 + ", gdsKey=" + this.gdsKey + ", offset1=" + this.offset1 + ", offset2=" + this.offset2 + ", refTime=" + this.refTime + ", forecastTime=" + this.forecastTime + ", decimalScale=" + this.decimalScale + ", bmsExists=" + this.bmsExists + ", center=" + this.center + ", subCenter=" + this.subCenter + ", table=" + this.table + ", validTime=" + this.validTime + '}';
    }
}

