/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribReadTextIndex;
import ucar.grid.GridIndex;

public class GribReadIndex {
    private static Logger log = LoggerFactory.getLogger(GribReadIndex.class);
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Calendar calendar;

    public GribReadIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return null;
        }
        return this.open(location, ios);
    }

    public final GridIndex open(String location, InputStream ios) throws IOException {
        long start = System.currentTimeMillis();
        FilterInputStream dis = null;
        try {
            GridIndex gridIndex = new GridIndex();
            dis = new DataInputStream(new BufferedInputStream(ios));
            long lastModified = ((DataInputStream)dis).readLong();
            if (lastModified == 7597120008394602085L) {
                dis.close();
                dis = null;
                GridIndex gridIndex2 = new GribReadTextIndex().open(location);
                return gridIndex2;
            }
            Date baseTime = null;
            boolean grid_edition_1 = false;
            String line = ((DataInputStream)dis).readUTF();
            if (debugParse) {
                System.out.println(line);
            }
            String[] split = line.split("\\s");
            for (int i = 0; i < split.length; i += 2) {
                gridIndex.addGlobalAttribute(split[i], split[i + 1]);
                if (split[i].equals("basetime")) {
                    baseTime = this.dateFormat.parse(split[i + 1]);
                    continue;
                }
                if (!split[i].equals("grid_edition")) continue;
                grid_edition_1 = split[i + 1].equals("1");
            }
            int number = ((DataInputStream)dis).readInt();
            int i = 0;
            try {
                for (i = 0; i < number; ++i) {
                    GribGridRecord ggr = new GribGridRecord();
                    ggr.productType = ((DataInputStream)dis).readInt();
                    ggr.discipline = ((DataInputStream)dis).readInt();
                    ggr.category = ((DataInputStream)dis).readInt();
                    ggr.paramNumber = ((DataInputStream)dis).readInt();
                    ggr.typeGenProcess = ((DataInputStream)dis).readInt();
                    ggr.levelType1 = ((DataInputStream)dis).readInt();
                    ggr.levelValue1 = ((DataInputStream)dis).readFloat();
                    ggr.levelType2 = ((DataInputStream)dis).readInt();
                    ggr.levelValue2 = ((DataInputStream)dis).readFloat();
                    long refTime = ((DataInputStream)dis).readLong();
                    this.calendar.setTimeInMillis(refTime);
                    ggr.refTime = this.calendar.getTime();
                    ggr.forecastTime = ((DataInputStream)dis).readInt();
                    this.calendar.add(10, ggr.forecastTime);
                    ggr.setValidTime(this.calendar.getTime());
                    ggr.gdsKey = ((DataInputStream)dis).readInt();
                    ggr.offset1 = ((DataInputStream)dis).readLong();
                    ggr.offset2 = ((DataInputStream)dis).readLong();
                    if (grid_edition_1) {
                        ggr.decimalScale = ((DataInputStream)dis).readInt();
                        ggr.bmsExists = ((DataInputStream)dis).readBoolean();
                        ggr.center = ((DataInputStream)dis).readInt();
                        ggr.subCenter = ((DataInputStream)dis).readInt();
                        ggr.table = ((DataInputStream)dis).readInt();
                    }
                    gridIndex.addGridRecord(ggr);
                }
            }
            catch (IOException e) {
                String message = "I/O error at record " + i + " in index file";
                log.error("open(): " + message + "[" + location + "]");
                throw new IOException(message, e);
            }
            while (!(line = ((DataInputStream)dis).readUTF()).equals("End")) {
                GribGridDefRecord gds = new GribGridDefRecord(line);
                gridIndex.addHorizCoordSys(gds);
            }
            if (debugTiming) {
                long took = System.currentTimeMillis() - start;
                System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
            }
            log.debug("Binary index read: " + location);
            log.debug("Number Records =" + gridIndex.getGridCount() + " at " + this.dateFormat.format(Calendar.getInstance().getTime()));
            GridIndex gridIndex3 = gridIndex;
            return gridIndex3;
        }
        catch (ParseException e) {
            log.error("open(): ParseException reading index " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        debugParse = flag;
    }

    public static void main(String[] args) throws IOException {
        File gbx = new File("C:/data/NDFD.grib2.gbx");
        if (!gbx.exists()) {
            gbx = new File("/local/robb/data/grib/idd/text/NDFD_CONUS_5km_20090221_1200.grib2.gbx");
        }
        if (args.length < 1) {
            GridIndex index = new GribReadIndex().open(gbx.getPath());
        } else {
            GridIndex index = new GribReadIndex().open(args[0]);
        }
        if (debugTiming) {
            return;
        }
    }
}

