/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grid.GridIndex;

public class GribReadTextIndex {
    private static Logger log = LoggerFactory.getLogger(GribReadTextIndex.class);
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    public static String currentTextIndexVersion = "6.5";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Calendar calendar;

    public GribReadTextIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return this.open(location, ios);
    }

    public GridIndex open(String location, InputStream ios) throws IOException {
        long start = System.currentTimeMillis();
        GridIndex gridIndex = new GridIndex();
        BufferedReader dataIS = null;
        boolean old_index_version = false;
        try {
            GribGridDefRecord gds;
            String line;
            String line2;
            dataIS = new BufferedReader(new InputStreamReader(ios));
            String centerS = null;
            String sub_centerS = null;
            String table_versionS = null;
            while (true) {
                if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                    GridIndex gridIndex2 = gridIndex;
                    return gridIndex2;
                }
                if (line2.startsWith("--")) break;
                int pos = line2.indexOf(" = ");
                if (pos <= 0) continue;
                String key = line2.substring(0, pos);
                String value = line2.substring(pos + 3).replaceAll(" ", "%20");
                gridIndex.addGlobalAttribute(key, value);
                if (key.equals("center")) {
                    centerS = value;
                    continue;
                }
                if (key.equals("sub_center")) {
                    sub_centerS = value;
                    continue;
                }
                if (key.equals("table_version")) {
                    table_versionS = value;
                    continue;
                }
                if (!key.equals("index_version")) continue;
                old_index_version = !value.startsWith(currentTextIndexVersion);
            }
            while (true) {
                if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                    GridIndex pos = gridIndex;
                    return pos;
                }
                if (line2.startsWith("--")) break;
                StringTokenizer stoke = new StringTokenizer(line2);
                String productType = stoke.nextToken();
                String discipline = stoke.nextToken();
                String category = stoke.nextToken();
                String param = stoke.nextToken();
                String typeGenProcess = stoke.nextToken();
                String levelType1 = stoke.nextToken();
                String levelValue1 = stoke.nextToken();
                String levelType2 = stoke.nextToken();
                String levelValue2 = stoke.nextToken();
                String refTime = stoke.nextToken();
                String foreTime = stoke.nextToken();
                String gdsKey = stoke.nextToken();
                if (old_index_version) {
                    gdsKey = Integer.toString(gdsKey.hashCode());
                }
                String offset1 = stoke.nextToken();
                String offset2 = stoke.nextToken();
                String decimalScale = stoke.hasMoreTokens() ? stoke.nextToken() : null;
                String bmsExists = stoke.hasMoreTokens() ? stoke.nextToken() : null;
                String center = stoke.hasMoreTokens() ? stoke.nextToken() : centerS;
                String subCenter = stoke.hasMoreTokens() ? stoke.nextToken() : sub_centerS;
                String table = stoke.hasMoreTokens() ? stoke.nextToken() : table_versionS;
                GribGridRecord ggr = new GribGridRecord(this.calendar, this.dateFormat, productType, discipline, category, param, typeGenProcess, levelType1, levelValue1, levelType2, levelValue2, refTime, foreTime, gdsKey, offset1, offset2, decimalScale, bmsExists, center, subCenter, table);
                gridIndex.addGridRecord(ggr);
                if (!debugParse) continue;
                System.out.println(ggr.toString());
            }
            StringBuilder sb = new StringBuilder();
            while ((line = dataIS.readLine()) != null && line.length() != 0) {
                if (line.startsWith("--")) {
                    gds = new GribGridDefRecord(sb.toString());
                    sb.setLength(0);
                    gridIndex.addHorizCoordSys(gds);
                    continue;
                }
                int pos = line.indexOf(" = ");
                if (line.startsWith("GDSkey")) {
                    if (old_index_version) {
                        int hc = line.substring(pos + 3).hashCode();
                        sb.append(line.substring(0, pos)).append("\t").append(Integer.toString(hc));
                        continue;
                    }
                    sb.append(line.substring(0, pos)).append("\t").append(line.substring(pos + 3));
                    continue;
                }
                if (pos <= 0) continue;
                sb.append("\t").append(line.substring(0, pos)).append("\t").append(line.substring(pos + 3));
            }
            gds = new GribGridDefRecord(sb.toString());
            gridIndex.addHorizCoordSys(gds);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start;
                System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
            }
            log.debug("Text index read: " + location);
            log.debug("Number Records =" + gridIndex.getGridCount() + " at " + this.dateFormat.format(Calendar.getInstance().getTime()));
            GridIndex gridIndex3 = gridIndex;
            return gridIndex3;
        }
        catch (IOException e) {
            log.error("open(): reading text index [" + location + "]");
            throw new IOException(e);
        }
        finally {
            if (dataIS != null) {
                dataIS.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File gbx = new File("C:/data/NDFD.grib2.gbx");
        if (!gbx.exists()) {
            gbx = new File("/local/robb/data/grib/ruc_sample.grib2.gbx");
        }
        if (args.length < 1) {
            GridIndex index = new GribReadTextIndex().open(gbx.getPath());
        } else {
            GridIndex index = new GribReadTextIndex().open(args[0]);
        }
        if (debugTiming) {
            return;
        }
    }
}

