/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class ShowGribIndex {
    private static boolean debugTiming = true;
    private static boolean debugParse = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static String divider = "------------------------------------------------------------------";

    public ShowGribIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final void open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return;
        }
        this.open(location, ios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(String location, InputStream ios) throws IOException {
        long start = System.currentTimeMillis();
        FilterInputStream dis = null;
        try {
            int i;
            dis = new DataInputStream(new BufferedInputStream(ios));
            long lastModified = ((DataInputStream)dis).readLong();
            if (lastModified == 7597120008394602085L) {
                dis.close();
                dis = null;
                this.openText(location);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTimeInMillis(lastModified);
            if (debugTiming) {
                System.out.println("Grib file " + location.replace(".gbx", "") + " was modified at " + this.dateFormat.format(calendar.getTime()));
            }
            String baseTime = null;
            boolean grid_edition_1 = false;
            String line = ((DataInputStream)dis).readUTF();
            if (debugParse) {
                System.out.println(line);
            }
            String[] split = line.split("\\s");
            for (int i2 = 0; i2 < split.length; i2 += 2) {
                System.out.println(split[i2] + " = " + split[i2 + 1]);
                if (split[i2].equals("baseTime")) {
                    baseTime = split[i2 + 1];
                    continue;
                }
                if (!split[i2].equals("grid_edition")) continue;
                grid_edition_1 = split[i2 + 1].equals("1");
            }
            System.out.println(divider);
            int number = ((DataInputStream)dis).readInt();
            int decimalScale = -9999;
            int center = -1;
            int subCenter = -1;
            int table = -1;
            boolean bmsExists = false;
            for (i = 0; i < number; ++i) {
                int productType = ((DataInputStream)dis).readInt();
                int discipline = ((DataInputStream)dis).readInt();
                int category = ((DataInputStream)dis).readInt();
                int param = ((DataInputStream)dis).readInt();
                int typeGenProcess = ((DataInputStream)dis).readInt();
                int levelType1 = ((DataInputStream)dis).readInt();
                float levelValue1 = ((DataInputStream)dis).readFloat();
                int levelType2 = ((DataInputStream)dis).readInt();
                float levelValue2 = ((DataInputStream)dis).readFloat();
                long refTime = ((DataInputStream)dis).readLong();
                int foreTime = ((DataInputStream)dis).readInt();
                int gdsKey = ((DataInputStream)dis).readInt();
                long offset1 = ((DataInputStream)dis).readLong();
                long offset2 = ((DataInputStream)dis).readLong();
                if (grid_edition_1) {
                    decimalScale = ((DataInputStream)dis).readInt();
                    bmsExists = ((DataInputStream)dis).readBoolean();
                    center = ((DataInputStream)dis).readInt();
                    subCenter = ((DataInputStream)dis).readInt();
                    table = ((DataInputStream)dis).readInt();
                }
                calendar.setTimeInMillis(refTime);
                System.out.print(productType + " " + discipline + " " + category + " " + param + " " + typeGenProcess + " " + levelType1 + " " + levelValue1 + " " + levelType2 + " " + levelValue2 + " " + this.dateFormat.format(calendar.getTime()) + " " + foreTime + " " + gdsKey + " " + offset1 + " " + offset2);
                if (grid_edition_1) {
                    System.out.println(" " + decimalScale + " " + bmsExists + " " + center + " " + subCenter + " " + table);
                    continue;
                }
                System.out.println();
            }
            while (!(line = ((DataInputStream)dis).readUTF()).equals("End")) {
                System.out.println(divider);
                split = line.split("\\t");
                for (i = 0; i < split.length; i += 2) {
                    System.out.println(split[i] + " = " + split[i + 1]);
                }
            }
            if (debugTiming) {
                long took = System.currentTimeMillis() - start;
                System.out.println("Index read " + location + " took=" + took + " msec ");
            }
            return;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public final void openText(String location) throws IOException {
        String line;
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null && line.length() != 0) {
            System.out.println(line);
        }
        dataIS.close();
    }

    public static void main(String[] args) throws IOException {
        String testName = "C:/data/NDFD.grib2.gbx";
        debugTiming = false;
        if (args.length < 1) {
            new ShowGribIndex().open("C:/data/NDFD.grib2.gbx");
        } else {
            new ShowGribIndex().open(args[0]);
        }
    }
}

