/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.GribReadIndex;
import ucar.grib.Index;

public class TestGribReadIndex {
    private void readIndex(int stop, String sDir) throws IOException {
        Date nowB = Calendar.getInstance().getTime();
        Date nowT = Calendar.getInstance().getTime();
        System.out.println(nowB.toString() + " ... Start of TestGribReadIndex\n");
        String bDir = sDir + File.separator + "binary";
        String tDir = sDir + File.separator + "text";
        File bdir = new File(bDir);
        File tdir = new File(tDir);
        int count = 0;
        long btotal = 0L;
        long ttotal = 0L;
        String[] bargs = new String[2];
        String[] targs = new String[2];
        System.out.println("\nIndex file             Binary read time  Text Read Time\n");
        if (bdir.isDirectory()) {
            String[] children;
            for (String child : children = bdir.list()) {
                if (!child.endsWith("gbx")) continue;
                if (count == stop) break;
                ++count;
                System.out.print(child);
                bargs[0] = bdir + File.separator + child;
                long bstart = System.currentTimeMillis();
                GribReadIndex.main(bargs);
                long btime = System.currentTimeMillis() - bstart;
                btotal += btime;
                System.out.print("  " + btime);
                targs[0] = tdir + File.separator + child;
                long tstart = System.currentTimeMillis();
                Index.main(targs);
                long ttime = System.currentTimeMillis() - tstart;
                ttotal += ttime;
                System.out.println("  " + ttime);
            }
        }
        System.out.println("\nTotal number of indexes read " + count);
        System.out.println("\nStatistics for Binary gbx reads");
        System.out.println("Total time = " + btotal + " msec");
        System.out.println("Avg time = " + btotal / (long)count + " msec");
        System.out.println("\nStatistics for Text gbx reads");
        System.out.println("Total time = " + ttotal + " msec");
        System.out.println("Avg time = " + ttotal / (long)count + " msec");
    }

    public static void main(String[] args) throws IOException {
        TestGribReadIndex tg2ri = new TestGribReadIndex();
        tg2ri.readIndex(Integer.parseInt(args[0]), args[1]);
    }
}

