/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.unidata.io.RandomAccessFile;

public class Grib1GridDefinitionSection {
    private static int[] bitsmv1 = new int[31];
    private int length;
    private int P_VorL;
    protected int[] numPV;
    private boolean isThin = false;
    protected int type;
    protected String name = "";
    protected int nx;
    protected int ny;
    protected double lat1;
    protected double lon1;
    protected double lat2;
    protected double lon2;
    protected double lov;
    protected int resolution;
    protected double dx;
    protected double dy;
    protected String grid_units;
    private int np;
    protected int scan;
    private int proj_center;
    private double latin1;
    private double latin2;
    private double latsp;
    private double lonsp;
    private double angle;
    protected String checksum = "";
    protected int gdskey;

    public Grib1GridDefinitionSection() {
    }

    public Grib1GridDefinitionSection(RandomAccessFile raf) throws IOException, NoValidGribException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.uint3(raf);
        if (this.length == 0) {
            raf.skipBytes(-2);
            this.length = GribNumbers.uint3(raf);
        }
        sectionEnd += (long)this.length;
        int NV = raf.read();
        this.P_VorL = raf.read();
        this.type = raf.read();
        double checkSum = this.type;
        this.name = Grib1GridDefinitionSection.getName(this.type);
        if (this.type != 50) {
            this.nx = raf.readShort();
            this.nx = this.nx == -1 ? 1 : this.nx;
            checkSum = 7.0 * checkSum + (double)this.nx;
            this.ny = raf.readShort();
            this.ny = this.ny == -1 ? 1 : this.ny;
            checkSum = 7.0 * checkSum + (double)this.ny;
            this.lat1 = (double)GribNumbers.int3(raf) / 1000.0;
            checkSum = 7.0 * checkSum + this.lat1;
            this.lon1 = (double)GribNumbers.int3(raf) / 1000.0;
            checkSum = 7.0 * checkSum + this.lon1;
            this.resolution = raf.read();
        }
        switch (this.type) {
            case 0: 
            case 4: 
            case 10: 
            case 40: 
            case 201: 
            case 202: {
                this.grid_units = "degrees";
                this.lat2 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lat2;
                this.lon2 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lon2;
                this.dx = this.smartRead(raf, 16, 1000.0);
                if (this.type == 4) {
                    this.np = raf.readShort();
                } else {
                    this.dy = this.smartRead(raf, 16, 1000.0);
                }
                this.scan = raf.read();
                int reserved = raf.readInt();
                if (this.type == 10) {
                    this.latsp = (double)GribNumbers.int3(raf) / 1000.0;
                    checkSum = 7.0 * checkSum + this.latsp;
                    this.lonsp = (double)GribNumbers.int3(raf) / 1000.0;
                    checkSum = 7.0 * checkSum + this.lonsp;
                    this.angle = raf.readFloat();
                }
                if (this.P_VorL == 255) break;
                if (NV == 0 || NV == 255) {
                    this.getPL(raf);
                    break;
                }
                this.getPV(NV, raf);
                break;
            }
            case 1: {
                this.grid_units = "m";
                this.lat2 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lat2;
                this.lon2 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lon2;
                this.latin1 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.latin1;
                int reserved = raf.read();
                this.scan = raf.read();
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                reserved = raf.readInt();
                reserved = raf.readInt();
                if (this.P_VorL == 255) break;
                if (NV == 0 || NV == 255) {
                    this.getPL(raf);
                    break;
                }
                this.getPV(NV, raf);
                break;
            }
            case 3: {
                this.grid_units = "m";
                this.lov = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lov;
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                this.proj_center = raf.read();
                this.scan = raf.read();
                this.latin1 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.latin1;
                this.latin2 = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.latin2;
                this.latsp = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.latsp;
                this.lonsp = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lonsp;
                short reserved = raf.readShort();
                if (this.P_VorL == 255) break;
                if (NV == 0 || NV == 255) {
                    this.getPL(raf);
                    break;
                }
                this.getPV(NV, raf);
                break;
            }
            case 5: 
            case 87: {
                this.grid_units = "m";
                this.lov = (double)GribNumbers.int3(raf) / 1000.0;
                checkSum = 7.0 * checkSum + this.lov;
                if (this.type == 87) {
                    this.lon2 = (double)GribNumbers.int3(raf) / 1000.0;
                    checkSum = 7.0 * checkSum + this.lon2;
                }
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                this.proj_center = raf.read();
                this.scan = raf.read();
                int reserved = GribNumbers.int4(raf);
                if (this.P_VorL == 255) break;
                if (NV == 0 || NV == 255) {
                    this.getPL(raf);
                    break;
                }
                this.getPV(NV, raf);
                break;
            }
            default: {
                System.out.println("Unknown Grid Type : " + this.type);
                throw new NoValidGribException("GDS: Unknown Grid Type : " + this.type + ") is not supported.");
            }
        }
        this.gdskey = Double.toString(checkSum).hashCode();
        this.checksum = Integer.toString(this.gdskey);
        if ((this.scan & 0x3F) != 0) {
            throw new NoValidGribException("GDS: This scanning mode (" + this.scan + ") is not supported.");
        }
        raf.seek(sectionEnd);
    }

    private double smartRead(RandomAccessFile raf, int bits, double divider) throws IOException {
        if (bits == 16) {
            short s = raf.readShort();
            if (s == -1) {
                return -9999.0;
            }
            return (double)s / divider;
        }
        if (bits == 24) {
            int i = GribNumbers.int3(raf);
            if (i == -1) {
                return -9999.0;
            }
            return (double)i / divider;
        }
        return -9999.0;
    }

    private void getPL(RandomAccessFile raf) throws IOException {
        this.isThin = true;
        int numPts = (this.scan & 0x20) == 0 ? this.ny : this.nx;
        int maxPts = 0;
        this.numPV = new int[numPts];
        for (int i = 0; i < numPts; ++i) {
            this.numPV[i] = raf.readUnsignedShort();
            if (maxPts >= this.numPV[i]) continue;
            maxPts = this.numPV[i];
        }
        if ((this.scan & 0x20) == 0) {
            this.nx = maxPts;
        } else {
            this.ny = maxPts;
        }
        if (this.lon2 < this.lon1) {
            this.lon2 += 360.0;
        }
        this.dx = (float)(this.lon2 - this.lon1) / (float)(this.nx - 1);
    }

    private void getPV(int NV, RandomAccessFile raf) throws IOException {
        float[] numPV = new float[NV];
        for (int i = 0; i < NV; ++i) {
            numPV[i] = raf.readFloat();
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean getIsThin() {
        return this.isThin;
    }

    public final int[] getNumPV() {
        return this.numPV;
    }

    public final int getGridType() {
        return this.type;
    }

    public final int getGdtn() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public static String getName(int type) {
        switch (type) {
            case 0: {
                return "Latitude/Longitude Grid";
            }
            case 1: {
                return "Mercator Projection Grid";
            }
            case 2: {
                return "Gnomonic Projection Grid";
            }
            case 3: {
                return "Lambert Conformal";
            }
            case 4: {
                return "Gaussian Latitude/Longitude";
            }
            case 5: 
            case 87: {
                return "Polar Stereographic projection Grid";
            }
            case 6: {
                return "Universal Transverse Mercator";
            }
            case 7: {
                return "Simple polyconic projection";
            }
            case 8: {
                return "Albers equal-area, secant or tangent, conic or bi-polar, projection";
            }
            case 9: {
                return "Miller's cylindrical projection";
            }
            case 10: {
                return "Rotated latitude/longitude grid";
            }
            case 13: {
                return "Oblique Lambert conformal, secant or tangent, conical or bipolar, projection";
            }
            case 14: {
                return "Rotated Gaussian latitude/longitude grid";
            }
            case 20: {
                return "Stretched latitude/longitude grid";
            }
            case 24: {
                return "Stretched Gaussian latitude/longitude grid";
            }
            case 30: {
                return "Stretched and rotated latitude/longitude grids";
            }
            case 34: {
                return "Stretched and rotated Gaussian latitude/longitude grids";
            }
            case 50: {
                return "Spherical Harmonic Coefficients";
            }
            case 60: {
                return "Rotated spherical harmonic coefficients";
            }
            case 70: {
                return "Stretched spherical harmonics";
            }
            case 80: {
                return "Stretched and rotated spherical harmonic coefficients";
            }
            case 90: {
                return "Space view perspective or orthographic";
            }
            case 201: {
                return "Arakawa semi-staggered E-grid on rotated latitude/longitude grid-point array";
            }
            case 202: {
                return "Arakawa filled E-grid on rotated latitude/longitude grid-point array";
            }
        }
        return "Unknown";
    }

    public final int getNx() {
        return this.nx;
    }

    public final int getNy() {
        return this.ny;
    }

    public final double getLa1() {
        return this.lat1;
    }

    public final double getLo1() {
        return this.lon1;
    }

    public final int getResolution() {
        return this.resolution;
    }

    public final int getShape() {
        int res = this.resolution >> 6;
        if (res == 1 || res == 3) {
            return 1;
        }
        return 0;
    }

    public final String getShapeName() {
        return Grib1GridDefinitionSection.getShapeName(this.getShape());
    }

    public static String getShapeName(int code) {
        if (code == 1) {
            return "oblate spheroid";
        }
        return "spherical";
    }

    public static final double getShapeRadius() {
        return 6367.47;
    }

    public static final double getShapeMajorAxis() {
        return 6378.16;
    }

    public static final double getShapeMinorAxis() {
        return 6356.775;
    }

    public final double getLa2() {
        return this.lat2;
    }

    public final double getLo2() {
        return this.lon2;
    }

    public final double getLov() {
        return this.lov;
    }

    public final double getLad() {
        return 0.0;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public String getGrid_units() {
        return this.grid_units;
    }

    public final double getNp() {
        return this.np;
    }

    public final int getScanMode() {
        return this.scan;
    }

    public final int getProjectionCenter() {
        return this.proj_center;
    }

    public final double getLatin() {
        return this.latin1;
    }

    public final double getLatin1() {
        return this.latin1;
    }

    public final double getLatin2() {
        return this.latin2;
    }

    public final double getSpLat() {
        return this.latsp;
    }

    public final double getSpLon() {
        return this.lonsp;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final String getCheckSum() {
        return this.checksum;
    }

    public final int getGdsKey() {
        return this.gdskey;
    }

    static {
        for (int i = 0; i < 31; ++i) {
            Grib1GridDefinitionSection.bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
    }
}

