/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;

public class Grib1GridTableLookup
implements GridTableLookup {
    private static Logger logger = LoggerFactory.getLogger(Grib1GridTableLookup.class);
    private final Grib1ProductDefinitionSection firstPDS;

    public Grib1GridTableLookup(Grib1Record firstRecord) {
        this.firstPDS = firstRecord.getPDS();
    }

    public final String getGridName(GridDefRecord gds) {
        return Grib1GridDefinitionSection.getName(gds.getParamInt("grid_type"));
    }

    public final String getShapeName(GridDefRecord gds) {
        return Grib1GridDefinitionSection.getShapeName(gds.getParamInt("grid_shape_code"));
    }

    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    public final GridParameter getParameter(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        try {
            GribPDSParamTable pt = GribPDSParamTable.getParameterTable(ggr.center, ggr.subCenter, ggr.table);
            return pt.getParameter(ggr.paramNumber);
        }
        catch (NotSupportedException noSupport) {
            logger.error("Grib1GridTableLookup: Parameter " + ggr.paramNumber + " not found for center" + ggr.center + " subcenter " + ggr.subCenter + " table number " + ggr.table);
            logger.error("NotSupportedException : " + noSupport);
            return new GridParameter();
        }
    }

    public int[] getParameterId(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int[] result = new int[]{1, ggr.center, ggr.table, ggr.paramNumber};
        return result;
    }

    public final String getProductDefinitionName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib1ProductDefinitionSection.getProductDefinitionName(ggr.productType);
    }

    public final String getTypeGenProcessName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib1ProductDefinitionSection.getTypeGenProcessName(ggr.typeGenProcess);
    }

    public final String getLevelName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getNameShort(ggr.levelType1);
    }

    public final String getLevelDescription(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getLevelDescription(ggr.levelType1);
    }

    public final String getLevelUnit(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getUnits(ggr.levelType1);
    }

    public final Date getFirstBaseTime() {
        return this.firstPDS.getBaseTime();
    }

    public final String getFirstTimeRangeUnitName() {
        return this.firstPDS.getTimeUnit();
    }

    public final String getFirstCenterName() {
        return this.firstPDS.getCenter_idName();
    }

    public final int getFirstSubcenterId() {
        return this.firstPDS.getSubCenter();
    }

    public final String getFirstProductStatusName() {
        return null;
    }

    public final String getFirstProductTypeName() {
        return Grib1ProductDefinitionSection.getProductDefinitionName(this.firstPDS.getTimeRange());
    }

    public final String getFirstSignificanceOfRTName() {
        return "Start of forecast";
    }

    public final boolean isLatLon(GridDefRecord gds) {
        int grid_type = gds.getParamInt("grid_type");
        return grid_type == 0 || grid_type == 4 || grid_type == 14 || grid_type == 24 || grid_type == 34;
    }

    public final int getProjectionType(GridDefRecord gds) {
        switch (gds.getParamInt("grid_type")) {
            case 1: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 10: {
                return 10;
            }
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.levelType1 == 20) {
            return true;
        }
        if (ggr.levelType1 == 100) {
            return true;
        }
        if (ggr.levelType1 == 101) {
            return true;
        }
        if (ggr.levelType1 >= 103 && ggr.levelType1 <= 128) {
            return true;
        }
        if (ggr.levelType1 == 141) {
            return true;
        }
        return ggr.levelType1 == 160;
    }

    public final boolean isPositiveUp(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.levelType1 == 103) {
            return true;
        }
        if (ggr.levelType1 == 104) {
            return true;
        }
        if (ggr.levelType1 == 105) {
            return true;
        }
        if (ggr.levelType1 == 106) {
            return true;
        }
        if (ggr.levelType1 == 111) {
            return true;
        }
        if (ggr.levelType1 == 112) {
            return true;
        }
        return ggr.levelType1 == 125;
    }

    public final float getFirstMissingValue() {
        return -9999.0f;
    }

    public final boolean isLayer(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.levelType1 == 101) {
            return true;
        }
        if (ggr.levelType1 == 104) {
            return true;
        }
        if (ggr.levelType1 == 106) {
            return true;
        }
        if (ggr.levelType1 == 108) {
            return true;
        }
        if (ggr.levelType1 == 110) {
            return true;
        }
        if (ggr.levelType1 == 112) {
            return true;
        }
        if (ggr.levelType1 == 114) {
            return true;
        }
        if (ggr.levelType1 == 116) {
            return true;
        }
        if (ggr.levelType1 == 120) {
            return true;
        }
        if (ggr.levelType1 == 121) {
            return true;
        }
        if (ggr.levelType1 == 128) {
            return true;
        }
        return ggr.levelType1 == 141;
    }

    public final String getGridType() {
        return "GRIB-1";
    }
}

