/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribNumbers;
import ucar.grib.GribReadIndex;
import ucar.grib.GribReadTextIndex;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndexExtender;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.unidata.io.RandomAccessFile;

public class Grib1WriteIndex {
    private static boolean debugTiming = false;
    private static boolean verbose = false;
    private static boolean maintainIndexType = true;
    private final Calendar calendar = Calendar.getInstance();

    public Grib1WriteIndex() {
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex writeGribIndex(File grib, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        raf.order(0);
        return this.writeGribIndex(grib, gbxName, raf, makeIndex);
    }

    public final GridIndex writeGribIndex(File grib, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName, false)));
        GridIndex gindex = this.writeGribIndex(raf, grib.lastModified(), out, makeIndex);
        out.close();
        return gindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = new Date();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib1WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(Grib2WriteIndex.indexRafBufferSize);
        GridIndex index = makeIndex ? new GridIndex() : null;
        try {
            inputRaf.seek(0L);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 7.0");
            sb.append(" grid_edition 1");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            ArrayList products = g1i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    sb.append(" center " + pds.getCenter());
                    sb.append(" sub_center " + pds.getSubCenter());
                    sb.append(" table_version " + pds.getTableVersion());
                    sb.append(" basetime " + dateFormat.format(pds.getBaseTime()));
                    out.writeUTF(sb.toString());
                    if (makeIndex) {
                        String[] split = sb.toString().split("\\s");
                        for (int j = 0; j < split.length; j += 2) {
                            index.addGlobalAttribute(split[j], split[j + 1]);
                        }
                    }
                    out.writeInt(products.size());
                    if (verbose) {
                        System.out.println("Index created with number records =" + products.size());
                    }
                }
                out.writeInt(pds.getProductDefinition());
                out.writeInt(product.getDiscipline());
                out.writeInt(product.getCategory());
                out.writeInt(pds.getParameterNumber());
                out.writeInt(pds.getTypeGenProcess());
                out.writeInt(pds.getLevelType());
                out.writeFloat(pds.getLevelValue1());
                out.writeInt(255);
                out.writeFloat(pds.getLevelValue2());
                out.writeLong(pds.getRefTime());
                out.writeInt(pds.getForecastTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getDataOffset());
                out.writeLong(product.getEndRecordOffset());
                out.writeInt(pds.getDecimalScale());
                out.writeBoolean(pds.bmsExists());
                out.writeInt(pds.getCenter());
                out.writeInt(pds.getSubCenter());
                out.writeInt(pds.getTableVersion());
                if (makeIndex) {
                    GribGridRecord gr = new GribGridRecord(this.calendar, pds.getProductDefinition(), product.getDiscipline(), product.getCategory(), pds.getParameterNumber(), pds.getTypeGenProcess(), pds.getLevelType(), pds.getLevelValue1(), 255, pds.getLevelValue2(), pds.getBaseTime(), pds.getForecastTime(), product.getGDSkeyInt(), product.getDataOffset(), product.getEndRecordOffset(), pds.getDecimalScale(), pds.bmsExists(), pds.getCenter(), pds.getSubCenter(), pds.getTableVersion());
                    index.addGridRecord(gr);
                }
                ++count;
            }
            HashMap gdsHM = g1i.getGDSs();
            for (String key : gdsHM.keySet()) {
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                String gdsStr = this.printGDS(key, gds, out);
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = new GribGridDefRecord(gdsStr);
                index.addHorizCoordSys(ggdr);
            }
            out.writeUTF("End");
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return index;
    }

    public final GridIndex extendGribIndex(File grib, File gbx, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        raf.order(0);
        return this.extendGribIndex(grib, gbx, gbxName, raf, makeIndex);
    }

    public final GridIndex extendGribIndex(File grib, File gbx, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        GridIndex oldIndex = new GribReadIndex().open(gbxName);
        Map<String, String> attr = oldIndex.getGlobalAttributes();
        double version = Double.parseDouble(attr.get("index_version"));
        if (maintainIndexType && version < 7.0) {
            new Grib1IndexExtender().extendIndex(raf, gbx, null);
            return new GribReadTextIndex().open(gbxName);
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName + ".tmp", false)));
        GridIndex gindex = this.extendGribIndex(oldIndex, raf, grib.lastModified(), out, makeIndex);
        if (out.size() == 8) {
            out.close();
            File tidx = new File(gbxName + ".tmp");
            tidx.delete();
            gbx.setLastModified(grib.lastModified() + 1000L);
        } else {
            out.close();
            gbx.delete();
            File tidx = new File(gbxName + ".tmp");
            tidx.renameTo(gbx);
        }
        return gindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(GridIndex oldIndex, RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = new Date();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2ExtendIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(Grib2WriteIndex.indexRafBufferSize);
        List<GridRecord> oldRecords = oldIndex.getGridRecords();
        GridRecord gr = oldRecords.get(oldRecords.size() - 1);
        GribGridRecord ggr = (GribGridRecord)gr;
        GridIndex index = makeIndex ? new GridIndex() : null;
        try {
            inputRaf.seek(ggr.offset2);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 7.0");
            sb.append(" grid_edition 1");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            ArrayList products = g1i.getProducts();
            if (products.size() == 0) {
                index = null;
                GridIndex gridIndex = oldIndex;
                return gridIndex;
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    sb.append(" center " + pds.getCenter());
                    sb.append(" sub_center " + pds.getSubCenter());
                    sb.append(" table_version " + pds.getTableVersion());
                    sb.append(" basetime " + dateFormat.format(pds.getBaseTime()));
                    out.writeUTF(sb.toString());
                    if (makeIndex) {
                        String[] split = sb.toString().split("\\s");
                        for (int j = 0; j < split.length; j += 2) {
                            index.addGlobalAttribute(split[j], split[j + 1]);
                        }
                    }
                    out.writeInt(products.size() + oldIndex.getGridCount());
                    if (verbose) {
                        System.out.println("Index extended with old new records " + oldIndex.getGridCount() + "  " + products.size());
                    }
                    for (GridRecord ogr : oldRecords) {
                        GribGridRecord oggr = (GribGridRecord)ogr;
                        out.writeInt(oggr.productType);
                        out.writeInt(oggr.discipline);
                        out.writeInt(oggr.category);
                        out.writeInt(oggr.paramNumber);
                        out.writeInt(oggr.typeGenProcess);
                        out.writeInt(oggr.levelType1);
                        out.writeFloat((float)oggr.levelValue1);
                        out.writeInt(oggr.levelType2);
                        out.writeFloat((float)oggr.levelValue2);
                        out.writeLong(oggr.refTime.getTime());
                        out.writeInt(oggr.forecastTime);
                        out.writeInt(oggr.gdsKey);
                        out.writeLong(oggr.offset1);
                        out.writeLong(oggr.offset2);
                        out.writeInt(oggr.decimalScale);
                        out.writeBoolean(oggr.bmsExists);
                        out.writeInt(oggr.center);
                        out.writeInt(oggr.subCenter);
                        out.writeInt(oggr.table);
                        if (makeIndex) {
                            gr = new GribGridRecord(this.calendar, oggr.productType, oggr.discipline, oggr.category, oggr.paramNumber, oggr.typeGenProcess, oggr.levelType1, (float)oggr.levelValue1, oggr.levelType2, (float)oggr.levelValue2, oggr.refTime, oggr.forecastTime, oggr.gdsKey, oggr.offset1, oggr.offset2, oggr.decimalScale, oggr.bmsExists, oggr.center, oggr.subCenter, oggr.table);
                            index.addGridRecord(gr);
                        }
                        ++count;
                    }
                }
                out.writeInt(pds.getProductDefinition());
                out.writeInt(product.getDiscipline());
                out.writeInt(product.getCategory());
                out.writeInt(pds.getParameterNumber());
                out.writeInt(pds.getTypeGenProcess());
                out.writeInt(pds.getLevelType());
                out.writeFloat(pds.getLevelValue1());
                out.writeInt(255);
                out.writeFloat(pds.getLevelValue2());
                out.writeLong(pds.getRefTime());
                out.writeInt(pds.getForecastTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getDataOffset());
                out.writeLong(product.getEndRecordOffset());
                out.writeInt(pds.getDecimalScale());
                out.writeBoolean(pds.bmsExists());
                out.writeInt(pds.getCenter());
                out.writeInt(pds.getSubCenter());
                out.writeInt(pds.getTableVersion());
                if (makeIndex) {
                    gr = new GribGridRecord(this.calendar, pds.getProductDefinition(), product.getDiscipline(), product.getCategory(), pds.getParameterNumber(), pds.getTypeGenProcess(), pds.getLevelType(), pds.getLevelValue1(), 255, pds.getLevelValue2(), pds.getBaseTime(), pds.getForecastTime(), product.getGDSkeyInt(), product.getDataOffset(), product.getEndRecordOffset(), pds.getDecimalScale(), pds.bmsExists(), pds.getCenter(), pds.getSubCenter(), pds.getTableVersion());
                    index.addGridRecord(gr);
                }
                ++count;
            }
            ArrayList<String> alreadySeen = new ArrayList<String>();
            List<GridDefRecord> gdrList = oldIndex.getHorizCoordSys();
            for (GridDefRecord gdr : gdrList) {
                String paramsValues = gdr.getParamsValues();
                out.writeUTF(paramsValues);
                alreadySeen.add(gdr.getParam("GDSkey"));
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = (GribGridDefRecord)gdr;
                index.addHorizCoordSys(ggdr);
            }
            HashMap gdsHM = g1i.getGDSs();
            for (String key : gdsHM.keySet()) {
                if (alreadySeen.contains(key)) continue;
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                String gdsStr = this.printGDS(key, gds, out);
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = new GribGridDefRecord(gdsStr);
                index.addHorizCoordSys(ggdr);
                String[] split = gdsStr.split("\\t");
                for (int i = 0; i < split.length; i += 2) {
                    ggdr.addParam(split[i], split[i + 1]);
                }
            }
            out.writeUTF("End");
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return index;
    }

    protected String printGDS(String key, Grib1GridDefinitionSection gds, DataOutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("GDSkey\t" + key);
        sb.append("\tgrid_type\t" + gds.getGdtn());
        sb.append("\tgrid_name\t" + gds.getName());
        if (gds.getGdtn() != 50) {
            sb.append("\tgrid_shape_code\t" + gds.getShape());
            sb.append("\tgrid_shape\t" + gds.getShapeName());
            if (gds.getShape() == 0) {
                sb.append("\tgrid_radius_spherical_earth\t" + gds.getShapeRadius());
            } else {
                sb.append("\tgrid_major_axis_earth\t" + gds.getShapeMajorAxis());
                sb.append("\tgrid_minor_axis_earth\t" + gds.getShapeMinorAxis());
            }
            sb.append("\tNx\t" + gds.getNx());
            sb.append("\tNy\t" + gds.getNy());
            sb.append("\tLa1\t" + gds.getLa1());
            sb.append("\tLo1\t" + gds.getLo1());
            sb.append("\tResCompFlag\t" + gds.getResolution());
            String winds = GribNumbers.isBitSet(gds.getResolution(), 8) ? "Relative" : "True";
            sb.append("\tWinds\t" + winds);
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 4: 
            case 10: 
            case 40: 
            case 201: 
            case 202: {
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tDx\t" + gds.getDx());
                if (gds.getGdtn() == 4) {
                    sb.append("\tNumberParallels\t" + gds.getNp());
                } else {
                    sb.append("\tDy\t" + gds.getDy());
                }
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                if (gds.getGdtn() != 10) break;
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                sb.append("\tRotationAngle\t" + gds.getAngle());
                break;
            }
            case 1: {
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tLatin\t" + gds.getLatin());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                break;
            }
            case 3: {
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                sb.append("\tLatin1\t" + gds.getLatin1());
                sb.append("\tLatin2\t" + gds.getLatin2());
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                break;
            }
            case 5: {
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                break;
            }
            default: {
                sb.append("\tUnknown Grid Type\t" + gds.getGdtn());
            }
        }
        out.writeUTF(sb.toString());
        return sb.toString();
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1WriteIndex indexer = new Grib1WriteIndex();
        debugTiming = true;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib1WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        String gribName = args[0];
        File grib = new File(args[0]);
        long rafLastModified = grib.lastModified();
        if (args.length == 2) {
            String gbxName = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            File gbx = new File(gbxName);
            if (gbx.exists() && gbx.lastModified() > rafLastModified) {
                return;
            }
            if (gbx.exists()) {
                indexer.extendGribIndex(grib, gbx, gribName, gbxName, false);
            } else {
                indexer.writeGribIndex(grib, gribName, gbxName, false);
            }
        } else if (args.length == 1) {
            indexer.writeGribIndex(grib, gribName, gribName + ".gbx", false);
        }
    }
}

