/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.grib1.Grib1Indexer;
import ucar.grib.grib1.Grib1WriteIndex;

public class TestGrib1WriteIndex {
    private void indexer(String type, int stop, String sDir) throws IOException {
        long start = System.currentTimeMillis();
        Date now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... Start of TestGrib1WriteIndex");
        File dir = new File(sDir);
        int count = 0;
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + File.separator + dir.getName());
            for (String child : children = dir.list()) {
                if (!child.endsWith("grib1")) continue;
                if (count == stop) break;
                ++count;
                String[] args = new String[2];
                args[0] = dir + File.separator + child;
                if (type.equals("binary")) {
                    args[1] = dir + File.separator + "binary" + File.separator + child + ".gbx";
                    Grib1WriteIndex.main(args);
                    continue;
                }
                args[1] = dir + File.separator + "text" + File.separator + child + ".gbx";
                Grib1Indexer.main(args);
            }
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("Total time = " + total + " msec");
        System.out.println("Avg time = " + total / (long)count + " msec");
    }

    public static void main(String[] args) throws IOException {
        TestGrib1WriteIndex tg1wi = new TestGrib1WriteIndex();
        tg1wi.indexer(args[0], Integer.parseInt(args[1]), args[2]);
    }
}

