/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2BitMapSection {
    private final int length;
    private final int section;
    private final int bitMapIndicator;
    private boolean[] bitmap = null;
    private byte[] data;
    private int numberOfPoints;

    public Grib2BitMapSection(boolean createBM, RandomAccessFile raf, Grib2GridDefinitionSection gds) throws IOException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        sectionEnd += (long)this.length;
        this.section = raf.read();
        this.bitMapIndicator = raf.read();
        if (this.bitMapIndicator != 0) {
            return;
        }
        if (!createBM) {
            raf.seek(sectionEnd);
            return;
        }
        long t1 = System.currentTimeMillis();
        this.data = new byte[this.length - 6];
        raf.read(this.data);
        this.numberOfPoints = gds.getNumberPoints();
        raf.seek(sectionEnd);
    }

    public final int getBitmapIndicator() {
        return this.bitMapIndicator;
    }

    public final boolean[] getBitmap() {
        if (this.bitMapIndicator != 0) {
            return null;
        }
        if (this.bitmap == null && this.data != null) {
            boolean[] tmpBitmap = new boolean[this.numberOfPoints];
            int[] bitmask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
            for (int i = 0; i < tmpBitmap.length; ++i) {
                tmpBitmap[i] = (this.data[i / 8] & bitmask[i % 8]) != 0;
            }
            this.bitmap = tmpBitmap;
            this.data = null;
        }
        return this.bitmap;
    }
}

