/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.jpeg.jj2000.j2k.decoder.Grib2JpegDecoder;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2DataSection {
    private static final boolean debug = false;
    private static final Logger logger = LoggerFactory.getLogger(Grib2DataSection.class);
    private static boolean staticMissingValueInUse = true;
    private int length;
    private final int section;
    private float[] data;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int scanMode;
    private int count;
    private int Xlength;

    public Grib2DataSection(boolean getData, RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        if (!getData) {
            if (this.length > 0 && (long)this.length < raf.length()) {
                raf.skipBytes(this.length - 5);
            } else {
                this.length = 5;
            }
            return;
        }
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 0) {
            this.simpleUnpacking(raf, gds, drs, bms);
        } else if (dtn == 1) {
            this.data = null;
            logger.error("Matrix values - simple packing not implemented");
        } else if (dtn == 2) {
            this.complexUnpacking(raf, gds, drs, bms);
        } else if (dtn == 3) {
            this.complexUnpackingWithSpatial(raf, gds, drs, bms);
        } else if (dtn == 40 || dtn == 40000) {
            this.jpeg2000Unpacking(raf, gds, drs, bms);
        }
    }

    private void simpleUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int dtn = drs.getDataTemplateNumber();
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        int numberPoints = gds.getNumberPoints();
        this.data = new float[numberPoints];
        boolean[] bitmap = bms.getBitmap();
        if (bitmap == null) {
            for (int i = 0; i < numberPoints; ++i) {
                this.data[i] = (R + (float)this.bits2UInt(nb, raf) * EE) / DD;
            }
        } else {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (int i = 0; i < bitmap.length; ++i) {
                this.data[i] = bitmap[i] ? (R + (float)this.bits2UInt(nb, raf) * EE) / DD : R / DD;
            }
        }
        this.scanMode = gds.getScanMode();
        this.Xlength = gds.getNx();
        this.scanningModeCheck();
    }

    private void complexUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int numberPoints = gds.getNumberPoints();
        int NG = drs.getNumberOfGroups();
        if (NG == 0) {
            logger.error("Grib2DataSection.complexUnpacking : NG = 0 for file" + raf.getLocation());
            this.data = new float[numberPoints];
            if (mvm == 0) {
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = mv;
                }
            } else {
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = mv;
                }
            }
            return;
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            X1[i] = this.bits2UInt(nb, raf);
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            NB[i] = this.bits2UInt(nb, raf);
        }
        int[] L = new int[NG];
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            L[i] = ref + this.bits2UInt(nb, raf) * len_inc;
        }
        L[NG - 1] = drs.getLengthLastGroup();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[numberPoints];
        this.Xlength = gds.getNx();
        int[] bitsmv1 = new int[31];
        for (int i = 0; i < 31; ++i) {
            bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
        this.count = 0;
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            for (int j = 0; j < L[i]; ++j) {
                if (NB[i] == 0) {
                    if (mvm == 0) {
                        this.data[this.count++] = (R + (float)X1[i] * EE) / DD;
                        continue;
                    }
                    this.data[this.count++] = mv;
                    continue;
                }
                int X2 = this.bits2UInt(NB[i], raf);
                this.data[this.count++] = mvm == 0 ? (R + (float)(X1[i] + X2) * EE) / DD : (X2 == bitsmv1[NB[i]] ? mv : (R + (float)(X1[i] + X2) * EE) / DD);
            }
        }
        boolean[] bitmap = bms.getBitmap();
        if (bitmap != null) {
            int idx = 0;
            float[] tmp = new float[numberPoints];
            for (int i = 0; i < numberPoints; ++i) {
                tmp[i] = bitmap[i] ? this.data[idx++] : mv;
            }
            this.data = tmp;
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private void complexUnpackingWithSpatial(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        boolean[] bitmap;
        int i;
        int idx;
        int i2;
        int sign;
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int numberPoints = gds.getNumberPoints();
        int NG = drs.getNumberOfGroups();
        if (NG == 0) {
            logger.error("Grib2DataSection.complexUnpackingWithSpatial: NG = 0 for file" + raf.getLocation());
            this.data = new float[numberPoints];
            if (mvm == 0) {
                for (int i3 = 0; i3 < numberPoints; ++i3) {
                    this.data[i3] = mv;
                }
            } else {
                for (int i4 = 0; i4 < numberPoints; ++i4) {
                    this.data[i4] = mv;
                }
            }
            return;
        }
        int g1 = 0;
        int gMin = 0;
        int h1 = 0;
        int h2 = 0;
        int hMin = 0;
        int os = drs.getOrderSpatial();
        int ds = drs.getDescriptorSpatial();
        this.bitPos = 0;
        this.bitBuf = 0;
        ds = ds * 8 - 1;
        if (os == 1) {
            sign = this.bits2UInt(1, raf);
            g1 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                g1 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            gMin = this.bits2UInt(ds, raf);
            if (sign == 1) {
                gMin *= -1;
            }
        } else if (os == 2) {
            sign = this.bits2UInt(1, raf);
            h1 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                h1 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            h2 = this.bits2UInt(ds, raf);
            if (sign == 1) {
                h2 *= -1;
            }
            sign = this.bits2UInt(1, raf);
            hMin = this.bits2UInt(ds, raf);
            if (sign == 1) {
                hMin *= -1;
            }
        } else {
            System.out.println("DS error os=" + os + " ds =" + ds);
            return;
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i5 = 0; i5 < NG; ++i5) {
            X1[i5] = this.bits2UInt(nb, raf);
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i6 = 0; i6 < NG; ++i6) {
            NB[i6] = this.bits2UInt(nb, raf);
        }
        int[] L = new int[NG];
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i7 = 0; i7 < NG; ++i7) {
            L[i7] = ref + this.bits2UInt(nb, raf) * len_inc;
        }
        L[NG - 1] = drs.getLengthLastGroup();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[numberPoints];
        this.Xlength = gds.getNx();
        int[] bitsmv1 = new int[31];
        for (int i8 = 0; i8 < 31; ++i8) {
            bitsmv1[i8] = (int)Math.pow(2.0, i8) - 1;
        }
        this.count = 0;
        this.bitPos = 0;
        this.bitBuf = 0;
        for (i2 = 0; i2 < NG; ++i2) {
            for (int j = 0; j < L[i2]; ++j) {
                if (NB[i2] == 0) {
                    if (mvm == 0) {
                        this.data[this.count++] = X1[i2];
                        continue;
                    }
                    this.data[this.count++] = mv;
                    continue;
                }
                int X2 = this.bits2UInt(NB[i2], raf);
                this.data[this.count++] = mvm == 0 ? (float)(X1[i2] + X2) : (X2 == bitsmv1[NB[i2]] ? mv : (float)(X1[i2] + X2));
            }
        }
        if (os == 1) {
            if (mvm == 0) {
                i2 = 1;
                while (i2 < this.data.length) {
                    int n = i2++;
                    this.data[n] = this.data[n] + (float)gMin;
                }
                this.data[0] = g1;
                for (i2 = 1; i2 < this.data.length; ++i2) {
                    this.data[i2] = this.data[i2] + this.data[i2 - 1];
                }
            } else {
                int i9;
                float sum = 0.0f;
                float lastOne = mv;
                idx = 0;
                for (i9 = 0; i9 < this.data.length; ++i9) {
                    if (this.data[i9] == mv) continue;
                    if (idx == 0) {
                        this.data[i9] = g1;
                        lastOne = this.data[i9];
                        idx = i9 + 1;
                        continue;
                    }
                    int n = i9;
                    this.data[n] = this.data[n] + (float)gMin;
                }
                if (lastOne == mv) {
                    logger.error("DS bad spatial differencing data");
                    return;
                }
                for (i9 = idx; i9 < this.data.length; ++i9) {
                    if (this.data[i9] == mv) continue;
                    this.data[i9] = lastOne + (sum += this.data[i9]);
                    lastOne = this.data[i9];
                }
            }
        } else if (os == 2) {
            float hDiff = h2 - h1;
            float sum = 0.0f;
            if (mvm == 0) {
                int i10 = 2;
                while (i10 < this.data.length) {
                    int n = i10++;
                    this.data[n] = this.data[n] + (float)hMin;
                }
                this.data[0] = h1;
                this.data[1] = h2;
                sum = hDiff;
                for (i10 = 2; i10 < this.data.length; ++i10) {
                    this.data[i10] = this.data[i10 - 1] + (sum += this.data[i10]);
                }
            } else {
                int i11;
                idx = 0;
                float lastOne = mv;
                for (i11 = 0; i11 < this.data.length; ++i11) {
                    if (this.data[i11] == mv) continue;
                    if (idx == 0) {
                        this.data[i11] = h1;
                        sum = 0.0f;
                        lastOne = this.data[i11];
                        ++idx;
                        continue;
                    }
                    if (idx == 1) {
                        this.data[i11] = (float)h1 + hDiff;
                        sum = hDiff;
                        lastOne = this.data[i11];
                        idx = i11 + 1;
                        continue;
                    }
                    int n = i11;
                    this.data[n] = this.data[n] + (float)hMin;
                }
                if (lastOne == mv) {
                    logger.error("DS bad spatial differencing data");
                    return;
                }
                for (i11 = idx; i11 < this.data.length; ++i11) {
                    if (this.data[i11] == mv) continue;
                    this.data[i11] = lastOne + (sum += this.data[i11]);
                    lastOne = this.data[i11];
                }
            }
        }
        if (mvm == 0) {
            for (i = 0; i < this.data.length; ++i) {
                this.data[i] = (R + this.data[i] * EE) / DD;
            }
        } else {
            for (i = 0; i < this.data.length; ++i) {
                if (this.data[i] == mv) continue;
                this.data[i] = (R + this.data[i] * EE) / DD;
            }
        }
        if ((bitmap = bms.getBitmap()) != null) {
            int idx2 = 0;
            float[] tmp = new float[numberPoints];
            for (int i12 = 0; i12 < numberPoints; ++i12) {
                tmp[i12] = bitmap[i12] ? this.data[idx2++] : mv;
            }
            this.data = tmp;
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private void jpeg2000Unpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        Grib2JpegDecoder g2j = null;
        int numberPoints = 0;
        try {
            if (nb != 0) {
                String[] argv = new String[]{"-rate", Integer.toString(nb), "-verbose", "off"};
                g2j = new Grib2JpegDecoder(argv);
                byte[] buf = new byte[this.length - 5];
                raf.read(buf);
                g2j.decode(buf);
            }
            numberPoints = gds.getNumberPoints();
            this.data = new float[numberPoints];
            boolean[] bitmap = bms.getBitmap();
            if (nb == 0) {
                if (mvm == 0) {
                    for (int i = 0; i < numberPoints; ++i) {
                        this.data[i] = R;
                    }
                } else {
                    for (int i = 0; i < numberPoints; ++i) {
                        this.data[i] = mv;
                    }
                }
            } else if (bitmap == null) {
                if (g2j.data.length != numberPoints) {
                    this.data = null;
                    return;
                }
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = (R + (float)g2j.data[i] * EE) / DD;
                }
            } else {
                int j = 0;
                for (int i = 0; i < bitmap.length; ++i) {
                    this.data[i] = bitmap[i] ? (R + (float)g2j.data[j++] * EE) / DD : mv;
                }
            }
        }
        catch (NullPointerException npe) {
            logger.error("Grib2DataSection.jpeg2000Unpacking: bit rate too small nb =" + nb + " for file" + raf.getLocation());
            for (int i = 0; i < numberPoints; ++i) {
                this.data[i] = mv;
            }
            return;
        }
        this.scanMode = gds.getScanMode();
        this.scanningModeCheck();
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private void scanningModeCheck() {
        if (this.scanMode == 0 || this.scanMode == 64) {
            return;
        }
        if (this.scanMode == 128 || this.scanMode == 192) {
            int mid = this.Xlength / 2;
            for (int index = 0; index < this.data.length; index += this.Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = this.data[index + idx];
                    this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                    this.data[index + this.Xlength - idx - 1] = tmp;
                }
            }
            return;
        }
        int mid = this.Xlength / 2;
        for (int index = 0; index < this.data.length; index += this.Xlength) {
            int row = index / this.Xlength;
            if (row % 2 != 1) continue;
            for (int idx = 0; idx < mid; ++idx) {
                float tmp = this.data[index + idx];
                this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                this.data[index + this.Xlength - idx - 1] = tmp;
            }
        }
    }

    public final float[] getData() {
        return this.data;
    }

    public static boolean isStaticMissingValueInUse() {
        return staticMissingValueInUse;
    }

    public static void setStaticMissingValueInUse(boolean staticMissingValueInUse) {
        Grib2DataSection.staticMissingValueInUse = staticMissingValueInUse;
    }
}

