/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.ParameterTable;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2Dump {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans metadata");
        System.out.println("<output file> file to store results");
        System.out.println("<true or false> whether to read/display data too");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <output file> <true or false>");
        System.exit(0);
    }

    public static void main(String[] args) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Grib2Dump func = new Grib2Dump();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            Grib2Dump.usage(cl.getName());
        }
        boolean displayData = false;
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            if (args.length == 3) {
                raf = new RandomAccessFile(args[0], "r");
                ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                displayData = args[2].equalsIgnoreCase("true");
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[0], "r");
                if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false")) {
                    displayData = args[1].equalsIgnoreCase("true");
                } else {
                    ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            Grib2Input g2i = new Grib2Input(raf);
            g2i.scan(false, false);
            List<Grib2Record> records = g2i.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                Grib2Record record = records.get(i);
                Grib2IndicatorSection is = record.getIs();
                Grib2IdentificationSection id = record.getId();
                Grib2GridDefinitionSection gds = record.getGDS();
                Grib2ProductDefinitionSection pds = record.getPDS();
                ps.println("--------------------------------------------------------------------");
                ps.println("                        Header : " + record.getHeader());
                Grib2Dump.printIS(is, ps);
                Grib2Dump.printID(id, dateFormat, ps);
                Grib2Dump.printGDS(gds, ps);
                Grib2Dump.printPDS(is, pds, ps);
                if (!displayData) continue;
                float[] data = null;
                ps.println("--------------------------------------------------------------------");
                Grib2Data gd = new Grib2Data(raf);
                data = gd.getData(record.getGdsOffset(), record.getPdsOffset());
                if (data == null) break;
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
                break;
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
    }

    private static void printIS(Grib2IndicatorSection is, PrintStream ps) {
        ps.println("                    Discipline : " + is.getDiscipline() + " " + is.getDisciplineName());
        ps.println("                  GRIB Edition : " + is.getGribEdition());
        ps.println("                   GRIB length : " + is.getGribLength());
    }

    private static void printID(Grib2IdentificationSection id, SimpleDateFormat dateFormat, PrintStream ps) {
        ps.println("            Originating Center : " + id.getCenter_id() + " " + id.getCenter_idName());
        ps.println("        Originating Sub-Center : " + id.getSubcenter_id());
        ps.println("Significance of Reference Time : " + id.getSignificanceOfRT() + " " + id.getSignificanceOfRTName());
        ps.println("                Reference Time : " + dateFormat.format(id.getBaseTime()));
        ps.println("                Product Status : " + id.getProductStatus() + " " + id.getProductStatusName());
        ps.println("                  Product Type : " + id.getProductType() + " " + id.getProductTypeName());
    }

    private static void printGDS(Grib2GridDefinitionSection gds, PrintStream ps) {
        ps.println("         Number of data points : " + gds.getNumberPoints());
        ps.println("                     Grid Name : " + gds.getGdtn() + " " + gds.getName());
        String winds = GribNumbers.isBitSet(gds.getResolution(), 8) ? "Relative" : "True";
        switch (gds.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("                   Basic angle : " + gds.getAngle());
                ps.println("    Subdivisions of basic angle: " + gds.getSubdivisionsangle());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("   Latitude of last grid point : " + gds.getLa2());
                ps.println("  Longitude of last grid point : " + gds.getLo2());
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("         j direction increment : " + gds.getDy());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                if (gds.getGdtn() == 1) {
                    ps.println("     Latitude of southern pole : " + gds.getSpLat());
                    ps.println("    Longitude of southern pole : " + gds.getSpLon());
                    ps.println("                Rotation angle : " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 2) {
                    ps.println("              Latitude of pole : " + gds.getPoleLat());
                    ps.println("             Longitude of pole : " + gds.getPoleLon());
                    ps.println("             Stretching factor : " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 3) break;
                ps.println("     Latitude of southern pole : " + gds.getSpLat());
                ps.println("    Longitude of southern pole : " + gds.getSpLon());
                ps.println("                Rotation angle : " + gds.getRotationangle());
                ps.println("              Latitude of pole : " + gds.getPoleLat());
                ps.println("             Longitude of pole : " + gds.getPoleLon());
                ps.println("             Stretching factor : " + gds.getFactor());
                break;
            }
            case 10: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("   Latitude of last grid point : " + gds.getLa2());
                ps.println("  Longitude of last grid point : " + gds.getLo2());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("                   Basic angle : " + gds.getAngle());
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("         j direction increment : " + gds.getDy());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                break;
            }
            case 20: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                break;
            }
            case 30: {
                ps.println("                    Grid Shape : " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("                            Nx : " + gds.getNx());
                ps.println("                            Ny : " + gds.getNy());
                ps.println("                           La1 : " + gds.getLa1());
                ps.println("                           Lo1 : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LaD : " + gds.getLad());
                ps.println("                           LoV : " + gds.getLov());
                ps.println("                            Dx : " + gds.getDx());
                ps.println("                            Dy : " + gds.getDy());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("             Projection center : " + gds.getProjectionCenter());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("                        Latin1 : " + gds.getLatin1());
                ps.println("                        Latin2 : " + gds.getLatin2());
                ps.println("                         SpLat : " + gds.getSpLat());
                ps.println("                         SpLon : " + gds.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("                   Basic angle : " + gds.getAngle());
                ps.println("    Subdivisions of basic angle: " + gds.getSubdivisionsangle());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("   Latitude of last grid point : " + gds.getLa2());
                ps.println("  Longitude of last grid point : " + gds.getLo2());
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("             Stretching factor : " + gds.getFactor());
                ps.println("           Number of parallels : " + gds.getN());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                if (gds.getGdtn() == 41) {
                    ps.println("     Latitude of southern pole : " + gds.getSpLat());
                    ps.println("    Longitude of southern pole : " + gds.getSpLon());
                    ps.println("                Rotation angle : " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 42) {
                    ps.println("              Latitude of pole : " + gds.getPoleLat());
                    ps.println("             Longitude of pole : " + gds.getPoleLon());
                    ps.println("             Stretching factor : " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 43) break;
                ps.println("     Latitude of southern pole : " + gds.getSpLat());
                ps.println("    Longitude of southern pole : " + gds.getSpLon());
                ps.println("                Rotation angle : " + gds.getRotationangle());
                ps.println("              Latitude of pole : " + gds.getPoleLat());
                ps.println("             Longitude of pole : " + gds.getPoleLon());
                ps.println("             Stretching factor : " + gds.getFactor());
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                ps.println("     J - pentagonal resolution : " + gds.getJ());
                ps.println("     K - pentagonal resolution : " + gds.getK());
                ps.println("     M - pentagonal resolution : " + gds.getM());
                ps.println("Method used to define the norm : " + gds.getMethod());
                ps.println("     Mode indicating the order : " + gds.getMode());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                if (gds.getGdtn() == 51) {
                    ps.println("     Latitude of southern pole : " + gds.getSpLat());
                    ps.println("    Longitude of southern pole : " + gds.getSpLon());
                    ps.println("                Rotation angle : " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 52) {
                    ps.println("              Latitude of pole : " + gds.getPoleLat());
                    ps.println("             Longitude of pole : " + gds.getPoleLon());
                    ps.println("             Stretching factor : " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 53) break;
                ps.println("     Latitude of southern pole : " + gds.getSpLat());
                ps.println("    Longitude of southern pole : " + gds.getSpLon());
                ps.println("                Rotation angle : " + gds.getRotationangle());
                ps.println("              Latitude of pole : " + gds.getPoleLat());
                ps.println("             Longitude of pole : " + gds.getPoleLon());
                ps.println("             Stretching factor : " + gds.getFactor());
                break;
            }
            case 90: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("        Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("        Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("Latitude of sub-satellite point: " + gds.getLap());
                ps.println("  Longitude of sub-satellite pt: " + gds.getLop());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("      Dx i direction increment : " + gds.getDx());
                ps.println("      Dy j direction increment : " + gds.getDy());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("Xp-coordinate of sub-satellite : " + gds.getXp());
                ps.println("Yp-coordinate of sub-satellite : " + gds.getYp());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("                   Basic angle : " + gds.getAngle());
                ps.println("     Nr Altitude of the camera : " + gds.getAltitude());
                ps.println("       Xo-coordinate of origin : " + gds.getXo());
                ps.println("       Yo-coordinate of origin : " + gds.getYo());
                break;
            }
            case 100: {
                ps.println("   Exponent of 2 for intervals : " + gds.getN2());
                ps.println("   Exponent of 3 for intervals : " + gds.getN3());
                ps.println("           Number of intervals : " + gds.getNi());
                ps.println("            Number of diamonds : " + gds.getNd());
                ps.println("              Latitude of pole : " + gds.getPoleLat());
                ps.println("             Longitude of pole : " + gds.getPoleLon());
                ps.println("           Grid point position : " + gds.getPosition());
                ps.println("      Number order of diamonds : " + gds.getOrder());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("           Number of parallels : " + gds.getN());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                break;
            }
            case 110: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("         j direction increment : " + gds.getDy());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("             Projection center : " + gds.getProjectionCenter());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                break;
            }
            case 120: {
                ps.println("           Number of data bins : " + gds.getNb());
                ps.println("             Number of radials : " + gds.getNr());
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("            Offset from origin : " + gds.getDstart());
                ps.println("need code to get azi and adelta");
                break;
            }
            case 204: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("        Oblate earth major axis: " + gds.getMajorAxis());
                    ps.println("        Oblate earth minor axis: " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gds.getGrid_units());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                break;
            }
            default: {
                ps.println("Unknown Grid Type" + gds.getGdtn());
            }
        }
    }

    private static void printPDS(Grib2IndicatorSection is, Grib2ProductDefinitionSection pds, PrintStream ps) {
        ps.println("            Product Definition : " + pds.getProductDefinition() + " " + pds.getProductDefinitionName());
        ps.println("            Parameter Category : " + pds.getParameterCategory() + " " + ParameterTable.getCategoryName(is.getDiscipline(), pds.getParameterCategory()));
        ps.println("                Parameter Name : " + pds.getParameterNumber() + " " + ParameterTable.getParameterName(is.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber()));
        ps.println("               Parameter Units : " + ParameterTable.getParameterUnit(is.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber()));
        String tgp = pds.getTypeGenProcess();
        ps.println("       Generating Process Type : " + tgp + " " + Grib2ProductDefinitionSection.getTypeGenProcessName(tgp));
        ps.println("                  ForecastTime : " + pds.getForecastTime());
        ps.println("            First Surface Type : " + pds.getTypeFirstFixedSurface() + " " + pds.getTypeFirstFixedSurfaceName());
        ps.println("           First Surface value : " + pds.getValueFirstFixedSurface());
        ps.println("           Second Surface Type : " + pds.getTypeSecondFixedSurface() + " " + pds.getTypeSecondFixedSurfaceName());
        ps.println("          Second Surface value : " + pds.getValueSecondFixedSurface());
        if (pds.getProductDefinition() == 8) {
            ps.println("             End Time Interval : " + pds.getEndTI());
            ps.println("         Number of Time Ranges : " + pds.getTimeRanges());
            ps.print("        Info about Time Ranges : ");
            int[] info = pds.getTimeIncrement();
            for (int t = 0; t < info.length; ++t) {
                ps.print(info[t]);
                if (t >= info.length - 1) continue;
                ps.print(", ");
            }
            ps.println();
        }
    }
}

