/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;

public final class Grib2GridTableLookup
implements GridTableLookup {
    private static Logger logger = LoggerFactory.getLogger(Grib2GridTableLookup.class);
    private final Grib2ProductDefinitionSection firstPDS;
    private final Grib2IdentificationSection firstID;
    private final Grib2DataRepresentationSection firstDRS;

    public Grib2GridTableLookup(Grib2Record firstRecord) {
        this.firstPDS = firstRecord.getPDS();
        this.firstID = firstRecord.getId();
        this.firstDRS = firstRecord.getDRS();
    }

    public final String getGridName(GridDefRecord gds) {
        return Grib2GridDefinitionSection.getGridName(gds.getParamInt("grid_type"));
    }

    public final String getShapeName(GridDefRecord gds) {
        return Grib2GridDefinitionSection.getShapeName(gds.getParamInt("grid_shape_code"));
    }

    public final String getDisciplineName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getDisciplineName(ggr.discipline);
    }

    public final String getCategoryName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getCategoryName(ggr.discipline, ggr.category);
    }

    public GridParameter getParameter(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getParameter(ggr.discipline, ggr.category, ggr.paramNumber);
    }

    public int[] getParameterId(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int[] result = new int[]{2, ggr.discipline, ggr.category, ggr.paramNumber};
        return result;
    }

    public final String getProductDefinitionName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2ProductDefinitionSection.getProductDefinitionName(ggr.productType);
    }

    public final int getProductDefinition(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.productType;
    }

    public final String getTypeGenProcessName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2ProductDefinitionSection.getTypeGenProcessName(ggr.typeGenProcess);
    }

    public final int getTypeGenProcess(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess;
    }

    public final boolean isEnsemble(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess > 39999 && ggr.typeGenProcess < 50000;
    }

    public final String NumberOfForecastsInEnsemble(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int ensemble = this.getTypeGenProcess(ggr);
        if (ensemble < 41000) {
            return Integer.toString(ensemble - 40000);
        }
        if (ensemble < 42000) {
            return Integer.toString(ensemble - 41000);
        }
        if (ensemble < 43000) {
            return Integer.toString(ensemble - 42000);
        }
        if (ensemble < 44000) {
            return Integer.toString(ensemble - 43000);
        }
        if (ensemble < 45000) {
            return Integer.toString(ensemble - 44000);
        }
        if (ensemble < 46000) {
            return Integer.toString(ensemble - 45000);
        }
        if (ensemble < 47000) {
            return Integer.toString(ensemble - 46000);
        }
        return "-1";
    }

    public final String makeEnsembleName(GridRecord gr, GridTableLookup lookup) {
        if (!(lookup instanceof Grib2GridTableLookup)) {
            return "";
        }
        Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
        if (!g2lookup.isEnsemble(gr)) {
            return "";
        }
        int ensemble = g2lookup.getTypeGenProcess(gr);
        String ensembleName = "";
        int productDef = g2lookup.getProductDefinition(gr);
        if (productDef == 2) {
            ensembleName = ensemble < 41000 ? "unweightedMean" : (ensemble < 42000 ? "weightedMean" : (ensemble < 43000 ? "stdDev" : (ensemble < 44000 ? "stdDevNor" : (ensemble < 45000 ? "spread" : (ensemble < 46000 ? "anomaly" : (ensemble < 47000 ? "unweightedMeanCluster" : "unknownEnsemble"))))));
        } else if (productDef == 1 || productDef == 11) {
            ensembleName = ensemble < 41000 ? "Cntrl_high" : (ensemble < 42000 ? "Cntrl_low" : (ensemble < 43000 ? "Perturb_neg" : (ensemble < 44000 ? "Perturb_pos" : "unknownEnsemble")));
        }
        return ensembleName;
    }

    public final boolean isProbability(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess > 49999 && ggr.typeGenProcess < 60000;
    }

    public final String NumberOfForecastsInProbability(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int probability = this.getTypeGenProcess(ggr);
        if (probability < 51000) {
            return Integer.toString(probability - 50000);
        }
        if (probability < 52000) {
            return Integer.toString(probability - 51000);
        }
        if (probability < 53000) {
            return Integer.toString(probability - 52000);
        }
        if (probability < 54000) {
            return Integer.toString(probability - 53000);
        }
        if (probability < 55000) {
            return Integer.toString(probability - 54000);
        }
        if (probability < 56000) {
            return Integer.toString(probability - 55000);
        }
        if (probability < 57000) {
            return Integer.toString(probability - 56000);
        }
        return "-1";
    }

    public final String makeProbabilityName(GridRecord gr, GridTableLookup lookup) {
        if (!(lookup instanceof Grib2GridTableLookup)) {
            return "";
        }
        Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
        if (!g2lookup.isProbability(gr)) {
            return "";
        }
        int probability = g2lookup.getTypeGenProcess(gr);
        String probabilityName = "";
        int productDef = g2lookup.getProductDefinition(gr);
        if (productDef == 5) {
            probabilityName = probability < 51000 ? "belowLL" : (probability < 52000 ? "aboveUL" : (probability < 53000 ? "betweenLimits" : (probability < 54000 ? "aboveLL" : (probability < 55000 ? "belowUL" : "unknownProbability"))));
        }
        return probabilityName;
    }

    public final String getLevelName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2ProductDefinitionSection.getTypeSurfaceNameShort(ggr.levelType1);
    }

    public final String getLevelDescription(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2ProductDefinitionSection.getTypeSurfaceName(ggr.levelType1);
    }

    public final String getLevelUnit(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2ProductDefinitionSection.getTypeSurfaceUnit(ggr.levelType1);
    }

    public final Date getFirstBaseTime() {
        return this.firstID.getBaseTime();
    }

    public final String getFirstTimeRangeUnitName() {
        return Grib2ProductDefinitionSection.getTimeRangeUnitName(this.firstPDS.timeRangeUnit);
    }

    public final String getFirstCenterName() {
        return this.firstID.getCenter_idName();
    }

    public final int getFirstSubcenterId() {
        return this.firstID.getSubcenter_id();
    }

    public final String getFirstProductStatusName() {
        return this.firstID.getProductStatusName();
    }

    public final String getFirstProductTypeName() {
        return this.firstID.getProductTypeName();
    }

    public final String getFirstSignificanceOfRTName() {
        return this.firstID.getSignificanceOfRTName();
    }

    public final boolean isLatLon(GridDefRecord gds) {
        int grid_type = gds.getParamInt("grid_type");
        return grid_type == 0 || grid_type >= 40 && grid_type < 44;
    }

    public final int getProjectionType(GridDefRecord gds) {
        switch (gds.getParamInt("grid_type")) {
            case 1: {
                return 10;
            }
            case 10: {
                return 3;
            }
            case 20: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 5;
            }
            case 40: {
                return 8;
            }
            case 90: {
                return 7;
            }
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.levelType1 == 105) {
            return true;
        }
        String units = this.getLevelUnit(gr);
        if (units == null || units.length() == 0) {
            return false;
        }
        if (ggr.levelType1 == 0) {
            return false;
        }
        return ggr.levelType1 != 104;
    }

    public final boolean isPositiveUp(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.levelType1 != 20 && ggr.levelType1 != 100 && ggr.levelType1 != 106 && ggr.levelType1 != 160;
    }

    public final float getFirstMissingValue() {
        if (Grib2DataSection.isStaticMissingValueInUse()) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 0) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 1) {
            return this.firstDRS.getPrimaryMissingValue();
        }
        if (this.firstDRS.getMissingValueManagement() == 2) {
            return this.firstDRS.getSecondaryMissingValue();
        }
        return -9999.0f;
    }

    public final boolean isLayer(GridRecord gr) {
        return gr.getLevelType2() != 255;
    }

    public final String getGridType() {
        return "GRIB-2";
    }
}

