/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.GribPDSVariablesIF;

public final class Grib2PDSVariables
implements GribPDSVariablesIF {
    private static Logger log = LoggerFactory.getLogger(Grib2PDSVariables.class);
    private final byte[] input;
    private final int productDefinition;

    public Grib2PDSVariables(byte[] input) throws IOException {
        this.input = input;
        this.productDefinition = GribNumbers.int2(this.getInt(7), this.getInt(8));
    }

    private int calculateIncrement(int tui, int length) {
        switch (tui) {
            case 1: {
                return length;
            }
            case 10: {
                return 3 * length;
            }
            case 11: {
                return 6 * length;
            }
            case 12: {
                return 12 * length;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                return length;
            }
        }
        return -9999;
    }

    public final int getLength() {
        return GribNumbers.int4(this.getInt(0), this.getInt(1), this.getInt(2), this.getInt(3));
    }

    public final int getSection() {
        return this.getInt(4);
    }

    public final int getCoordinates() {
        return GribNumbers.int2(this.getInt(5), this.getInt(6));
    }

    public final int getProductDefinition() {
        return this.productDefinition;
    }

    public final int getParameterCategory() {
        return this.getInt(9);
    }

    public final int getParameterNumber() {
        return this.getInt(10);
    }

    public final int getTypeGenProcess() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 30: 
            case 31: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return this.getInt(11);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(13);
            }
        }
        return -9999;
    }

    public final int getChemicalType() {
        switch (this.productDefinition) {
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return GribNumbers.int2(this.getInt(11), this.getInt(12));
            }
        }
        return -9999;
    }

    public final int getBackGenProcess() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return this.getInt(12);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(14);
            }
        }
        return -9999;
    }

    public final int getObservationProcess() {
        switch (this.productDefinition) {
            case 30: 
            case 31: {
                return this.getInt(12);
            }
        }
        return -9999;
    }

    public final int getNB() {
        switch (this.productDefinition) {
            case 30: 
            case 31: {
                return this.getInt(13);
            }
        }
        return -9999;
    }

    public final int getAnalysisGenProcess() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return this.getInt(13);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(15);
            }
        }
        return -9999;
    }

    public final int getHoursAfter() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return GribNumbers.int2(this.getInt(14), this.getInt(15));
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return GribNumbers.int2(this.getInt(16), this.getInt(17));
            }
        }
        return -9999;
    }

    public final int getMinutesAfter() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return this.getInt(16);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(18);
            }
        }
        return -9999;
    }

    public final int getTimeRangeUnit() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return this.getInt(17);
            }
            case 20: {
                return this.getInt(13);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(19);
            }
        }
        return -9999;
    }

    public final int getForecastTime() {
        int forecast1 = GribNumbers.int4(this.getInt(18), this.getInt(19), this.getInt(20), this.getInt(21)) * this.calculateIncrement(this.getTimeRangeUnit(), 1);
        int forecast2 = GribNumbers.int4(this.getInt(20), this.getInt(21), this.getInt(22), this.getInt(23)) * this.calculateIncrement(this.getTimeRangeUnit(), 1);
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1100: 
            case 1101: {
                return forecast1;
            }
            case 8: {
                return this.calculateForecast(41, forecast1);
            }
            case 9: {
                return this.calculateForecast(54, forecast1);
            }
            case 10: {
                return this.calculateForecast(42, forecast1);
            }
            case 11: {
                return this.calculateForecast(44, forecast1);
            }
            case 12: {
                return this.calculateForecast(43, forecast1);
            }
            case 13: {
                return this.calculateForecast(75, forecast1);
            }
            case 14: {
                return this.calculateForecast(71, forecast1);
            }
            case 40: 
            case 41: {
                return GribNumbers.int4(this.getInt(20), this.getInt(21), this.getInt(22), this.getInt(23)) * this.calculateIncrement(this.getTimeRangeUnit(), 1);
            }
            case 42: {
                return this.calculateForecast(43, forecast2);
            }
            case 43: {
                return this.calculateForecast(46, forecast2);
            }
        }
        return -9999;
    }

    public final int calculateForecast(int idx, int forecastTime) {
        int timeRanges = this.getInt(idx++);
        int missingDataValues = GribNumbers.int4(this.getInt(idx++), this.getInt(idx++), this.getInt(idx++), this.getInt(idx++));
        int[] timeIncrement = new int[timeRanges * 6];
        for (int t = 0; t < timeRanges; ++t) {
            timeIncrement[t * 6] = this.getInt(idx++);
            timeIncrement[t * 6 + 1] = this.getInt(idx++);
            timeIncrement[t * 6 + 2] = this.getInt(idx++);
            timeIncrement[t * 6 + 3] = GribNumbers.int4(this.getInt(idx++), this.getInt(idx++), this.getInt(idx++), this.getInt(idx++));
            timeIncrement[t * 6 + 4] = this.getInt(idx++);
            timeIncrement[t * 6 + 5] = GribNumbers.int4(this.getInt(idx++), this.getInt(idx++), this.getInt(idx++), this.getInt(idx++));
        }
        if (timeRanges == 1) {
            forecastTime += this.calculateIncrement(timeIncrement[2], timeIncrement[3]);
        } else {
            log.error("Grib2PDSVariable: innermost steps not implemented");
            forecastTime = -9999;
        }
        return forecastTime;
    }

    public final int getTypeFirstFixedSurface() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1100: 
            case 1101: {
                return this.getInt(22);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(24);
            }
        }
        return -9999;
    }

    public float getValueFirstFixedSurface() {
        int valueFirstFixedSurface;
        int scaleFirstFixedSurface;
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1100: 
            case 1101: {
                scaleFirstFixedSurface = this.getInt(23);
                valueFirstFixedSurface = GribNumbers.int4(this.getInt(24), this.getInt(25), this.getInt(26), this.getInt(27));
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                scaleFirstFixedSurface = this.getInt(25);
                valueFirstFixedSurface = GribNumbers.int4(this.getInt(26), this.getInt(27), this.getInt(28), this.getInt(29));
                break;
            }
            default: {
                return -9999.0f;
            }
        }
        return (float)(scaleFirstFixedSurface == 0 || valueFirstFixedSurface == 0 ? (double)valueFirstFixedSurface : (double)valueFirstFixedSurface * Math.pow(10.0, -scaleFirstFixedSurface));
    }

    public final int getTypeSecondFixedSurface() {
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1100: 
            case 1101: {
                return this.getInt(28);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.getInt(30);
            }
        }
        return -9999;
    }

    public float getValueSecondFixedSurface() {
        int valueSecondFixedSurface;
        int scaleSecondFixedSurface;
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1100: 
            case 1101: {
                scaleSecondFixedSurface = this.getInt(29);
                valueSecondFixedSurface = GribNumbers.int4(this.getInt(30), this.getInt(31), this.getInt(32), this.getInt(33));
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                scaleSecondFixedSurface = this.getInt(31);
                valueSecondFixedSurface = GribNumbers.int4(this.getInt(32), this.getInt(33), this.getInt(34), this.getInt(35));
                break;
            }
            default: {
                return -9999.0f;
            }
        }
        return (float)(scaleSecondFixedSurface == 0 || valueSecondFixedSurface == 0 ? (double)valueSecondFixedSurface : (double)valueSecondFixedSurface * Math.pow(10.0, -scaleSecondFixedSurface));
    }

    public final boolean isEnsemble() {
        switch (this.getTypeGenProcess()) {
            case 4: 
            case 5: 
            case 10: 
            case 193: {
                return true;
            }
        }
        return false;
    }

    public final int getType() {
        switch (this.productDefinition) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.getInt(34);
            }
            case 5: 
            case 9: 
            case 41: 
            case 43: {
                return this.getInt(36);
            }
        }
        return -9999;
    }

    public final int getForecastProbability() {
        switch (this.productDefinition) {
            case 5: 
            case 9: {
                return this.getInt(34);
            }
        }
        return -9999;
    }

    public final int getForecastPercentile() {
        switch (this.productDefinition) {
            case 6: 
            case 10: {
                return this.getInt(34);
            }
        }
        return -9999;
    }

    public final int getPerturbation() {
        switch (this.productDefinition) {
            case 1: 
            case 11: {
                return this.getInt(35);
            }
            case 41: 
            case 43: {
                return this.getInt(37);
            }
        }
        return -9999;
    }

    public final int getNumberForecasts() {
        switch (this.productDefinition) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                return this.getInt(35);
            }
            case 1: 
            case 11: {
                return this.getInt(36);
            }
            case 41: 
            case 43: {
                return this.getInt(38);
            }
        }
        return -9999;
    }

    public final float getValueLowerLimit() {
        int valueLowerLimit;
        int scaleLowerLimit;
        switch (this.productDefinition) {
            case 5: 
            case 9: {
                scaleLowerLimit = this.getInt(37);
                valueLowerLimit = GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
                break;
            }
            default: {
                return -9999.0f;
            }
        }
        return (float)(scaleLowerLimit == 0 || valueLowerLimit == 0 ? (double)valueLowerLimit : (double)valueLowerLimit * Math.pow(10.0, -scaleLowerLimit));
    }

    public final float getValueUpperLimit() {
        int valueUpperLimit;
        int scaleUpperLimit;
        switch (this.productDefinition) {
            case 5: 
            case 9: {
                scaleUpperLimit = this.getInt(42);
                valueUpperLimit = GribNumbers.int4(this.getInt(43), this.getInt(44), this.getInt(45), this.getInt(46));
                break;
            }
            default: {
                return -9999.0f;
            }
        }
        return (float)(scaleUpperLimit == 0 || valueUpperLimit == 0 ? (double)valueUpperLimit : (double)valueUpperLimit * Math.pow(10.0, -scaleUpperLimit));
    }

    public final int getInt(int index) {
        return this.input[index] & 0xFF;
    }
}

