/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2PDSVariables;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2ProductDefinitionSection {
    private final int length;
    private final int section;
    private final int coordinates;
    private final int productDefinition;
    private int parameterCategory;
    private int parameterNumber;
    private int typeGenProcess;
    private int backGenProcess;
    private int analysisGenProcess;
    private int hoursAfter;
    private int minutesAfter;
    protected int timeRangeUnit;
    private int forecastTime;
    private int typeFirstFixedSurface;
    private float FirstFixedSurfaceValue;
    private int typeSecondFixedSurface;
    private float SecondFixedSurfaceValue;
    private int typeEnsemble;
    private int perturbNumber;
    private int numberForecasts;
    private int nb;
    private Date endTI;
    private int timeRanges;
    private int[] timeIncrement;
    private float lowerLimit;
    private float upperLimit;
    private final byte[] pdsData;

    public Grib2ProductDefinitionSection(RandomAccessFile raf) throws IOException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        this.pdsData = new byte[this.length];
        raf.skipBytes(-4);
        raf.read(this.pdsData);
        raf.seek(sectionEnd + 4L);
        sectionEnd += (long)this.length;
        this.section = raf.read();
        this.coordinates = GribNumbers.int2(raf);
        this.productDefinition = GribNumbers.int2(raf);
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.analysisGenProcess = raf.read();
                this.hoursAfter = GribNumbers.int2(raf);
                this.minutesAfter = raf.read();
                this.timeRangeUnit = raf.read();
                this.forecastTime = GribNumbers.int4(raf) * this.calculateIncrement(this.timeRangeUnit, 1);
                this.typeFirstFixedSurface = raf.read();
                int scaleFirstFixedSurface = raf.read();
                int valueFirstFixedSurface = GribNumbers.int4(raf);
                this.FirstFixedSurfaceValue = (float)(scaleFirstFixedSurface == 0 || valueFirstFixedSurface == 0 ? (double)valueFirstFixedSurface : (double)valueFirstFixedSurface * Math.pow(10.0, -scaleFirstFixedSurface));
                this.typeSecondFixedSurface = raf.read();
                int scaleSecondFixedSurface = raf.read();
                int valueSecondFixedSurface = GribNumbers.int4(raf);
                this.SecondFixedSurfaceValue = (float)(scaleSecondFixedSurface == 0 || valueSecondFixedSurface == 0 ? (double)valueSecondFixedSurface : (double)valueSecondFixedSurface * Math.pow(10.0, -scaleSecondFixedSurface));
                try {
                    if (this.productDefinition == 1 || this.productDefinition == 11) {
                        this.typeEnsemble = raf.read();
                        this.perturbNumber = raf.read();
                        this.numberForecasts = raf.read();
                        if (this.productDefinition != 11) break;
                        raf.seek(sectionEnd);
                        break;
                    }
                    if (this.productDefinition == 2) {
                        this.typeEnsemble = raf.read();
                        this.numberForecasts = raf.read();
                        break;
                    }
                    if (this.productDefinition == 3) {
                        throw new NotSupportedException("PDS productDefinition = 3 not implemented");
                    }
                    if (this.productDefinition == 4) {
                        throw new NotSupportedException("PDS productDefinition = 4 not implemented");
                    }
                    if (this.productDefinition == 5) {
                        int probabilityNumber = raf.read();
                        this.numberForecasts = raf.read();
                        this.typeEnsemble = raf.read();
                        int scaleFactorLL = raf.read();
                        int scaleValueLL = GribNumbers.int4(raf);
                        this.lowerLimit = (float)(scaleFactorLL == 0 || scaleValueLL == 0 ? (double)scaleValueLL : (double)scaleValueLL * Math.pow(10.0, -scaleFactorLL));
                        int scaleFactorUL = raf.read();
                        int scaleValueUL = GribNumbers.int4(raf);
                        this.upperLimit = (float)(scaleFactorUL == 0 || scaleValueUL == 0 ? (double)scaleValueUL : (double)scaleValueUL * Math.pow(10.0, -scaleFactorUL));
                        break;
                    }
                    if (this.productDefinition == 6) {
                        throw new NotSupportedException("PDS productDefinition = 6 not implemented");
                    }
                    if (this.productDefinition == 7) {
                        throw new NotSupportedException("PDS productDefinition = 7 not implemented");
                    }
                    if (this.productDefinition == 8) {
                        int year = GribNumbers.int2(raf);
                        int month = raf.read() - 1;
                        int day = raf.read();
                        int hour = raf.read();
                        int minute = raf.read();
                        int second = raf.read();
                        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                        c.clear();
                        c.set(year, month, day, hour, minute, second);
                        this.endTI = c.getTime();
                        this.timeRanges = raf.read();
                        int missingDataValues = GribNumbers.int4(raf);
                        this.timeIncrement = new int[this.timeRanges * 6];
                        for (int t = 0; t < this.timeRanges; t += 6) {
                            this.timeIncrement[t] = raf.read();
                            this.timeIncrement[t + 1] = raf.read();
                            this.timeIncrement[t + 2] = raf.read();
                            this.timeIncrement[t + 3] = GribNumbers.int4(raf);
                            this.timeIncrement[t + 4] = raf.read();
                            this.timeIncrement[t + 5] = GribNumbers.int4(raf);
                        }
                        if (this.timeRanges == 1) {
                            this.forecastTime += this.calculateIncrement(this.timeIncrement[2], this.timeIncrement[3]);
                            break;
                        }
                        this.forecastTime = -9999;
                        break;
                    }
                    if (this.productDefinition != 9) break;
                    int probabilityNumber = raf.read();
                    this.numberForecasts = raf.read();
                    this.typeEnsemble = raf.read();
                    int scaleFactorLL = raf.read();
                    int scaleValueLL = GribNumbers.int4(raf);
                    this.lowerLimit = (float)(scaleFactorLL == 0 || scaleValueLL == 0 ? (double)scaleValueLL : (double)scaleValueLL * Math.pow(10.0, -scaleFactorLL));
                    int scaleFactorUL = raf.read();
                    int scaleValueUL = GribNumbers.int4(raf);
                    this.upperLimit = (float)(scaleFactorUL == 0 || scaleValueUL == 0 ? (double)scaleValueUL : (double)scaleValueUL * Math.pow(10.0, -scaleFactorUL));
                    int year = GribNumbers.int2(raf);
                    int month = raf.read() - 1;
                    int day = raf.read();
                    int hour = raf.read();
                    int minute = raf.read();
                    int second = raf.read();
                    GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    c.clear();
                    c.set(year, month, day, hour, minute, second);
                    this.endTI = c.getTime();
                    this.timeRanges = raf.read();
                    int missingDataValues = GribNumbers.int4(raf);
                    this.timeIncrement = new int[this.timeRanges * 6];
                    for (int t = 0; t < this.timeRanges; t += 6) {
                        this.timeIncrement[t] = raf.read();
                        this.timeIncrement[t + 1] = raf.read();
                        this.timeIncrement[t + 2] = raf.read();
                        this.timeIncrement[t + 3] = GribNumbers.int4(raf);
                        this.timeIncrement[t + 4] = raf.read();
                        this.timeIncrement[t + 5] = GribNumbers.int4(raf);
                    }
                    if (this.timeRanges == 1) {
                        this.forecastTime += this.calculateIncrement(this.timeIncrement[2], this.timeIncrement[3]);
                        break;
                    }
                    this.forecastTime = -9999;
                    break;
                }
                catch (NotSupportedException nse) {
                    nse.printStackTrace();
                }
            }
            case 20: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                break;
            }
            case 30: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.nb = raf.read();
                for (int j = 0; j < this.nb; ++j) {
                    raf.skipBytes(10);
                }
                break;
            }
            case 254: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                break;
            }
        }
        raf.seek(sectionEnd);
    }

    private int calculateIncrement(int tui, int length) {
        switch (tui) {
            case 1: {
                return length;
            }
            case 10: {
                return 3 * length;
            }
            case 11: {
                return 6 * length;
            }
            case 12: {
                return 12 * length;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                return length;
            }
        }
        return -9999;
    }

    public final int getCoordinates() {
        return this.coordinates;
    }

    public final int getProductDefinition() {
        return this.productDefinition;
    }

    public final String getProductDefinitionName() {
        return Grib2ProductDefinitionSection.getProductDefinitionName(this.productDefinition);
    }

    public static String getProductDefinitionName(int productDefinition) {
        switch (productDefinition) {
            case 0: {
                return "Analysis/forecast at horizontal level/layer";
            }
            case 1: {
                return "Individual ensemble forecast at a point in time";
            }
            case 2: {
                return "Derived forecast on all ensemble members";
            }
            case 3: {
                return "Derived forecasts on cluster of ensemble members over rectangular area";
            }
            case 4: {
                return "Derived forecasts on cluster of ensemble members over circular area";
            }
            case 5: {
                return "Probability forecasts at a horizontal level";
            }
            case 6: {
                return "Percentile forecasts at a horizontal level";
            }
            case 7: {
                return "Analysis or forecast error at a horizontal level";
            }
            case 8: {
                return "Average, accumulation, extreme values or other statistically processed value at a horizontal level";
            }
            case 11: {
                return "Individual ensemble forecast";
            }
            case 20: {
                return "Radar product";
            }
            case 30: {
                return "Satellite product";
            }
            case 254: {
                return "CCITTIA5 character string";
            }
        }
        return "Unknown";
    }

    public final int getParameterCategory() {
        return this.parameterCategory;
    }

    public final int getParameterNumber() {
        return this.parameterNumber;
    }

    public static final int getTypeEnsemble(String tgp) {
        if (tgp.contains("C_high")) {
            return 0;
        }
        if (tgp.contains("C_low")) {
            return 1;
        }
        if (tgp.contains("P_neg")) {
            return 2;
        }
        if (tgp.contains("P_pos")) {
            return 3;
        }
        return -9999;
    }

    public final String getTypeGenProcess() {
        if (this.typeGenProcess == 4) {
            String type = this.typeEnsemble == 0 ? "C_high" : (this.typeEnsemble == 1 ? "C_low" : (this.typeEnsemble == 2 ? "P_neg" : (this.typeEnsemble == 3 ? "P_pos" : "unknown")));
            return "4-" + type + "-" + Integer.toString(this.perturbNumber);
        }
        return Integer.toString(this.typeGenProcess);
    }

    public final int getTypeGenProcessNumeric() {
        return this.typeGenProcess;
    }

    public static final String getTypeGenProcessName(String typeGenProcess) {
        int tgp = typeGenProcess.startsWith("4") ? 4 : Integer.parseInt(typeGenProcess);
        return Grib2ProductDefinitionSection.getTypeGenProcessName(tgp);
    }

    public static final String getTypeGenProcessName(int typeGenProcess) {
        switch (typeGenProcess) {
            case 0: {
                return "Analysis";
            }
            case 1: {
                return "Initialization";
            }
            case 2: {
                return "Forecast";
            }
            case 3: {
                return "Bias Corrected Forecast";
            }
            case 4: {
                return "Ensemble Forecast";
            }
            case 5: {
                return "Probability Forecast";
            }
            case 6: {
                return "Forecast Error";
            }
            case 7: {
                return "Analysis Error";
            }
            case 8: {
                return "Observation";
            }
            case 255: {
                return "Missing";
            }
        }
        if (typeGenProcess > 3999 && typeGenProcess < 4400) {
            return "Ensemble Forecast";
        }
        return "Unknown";
    }

    public final int getBackGenProcess() {
        return this.backGenProcess;
    }

    public final int getAnalysisGenProcess() {
        return this.analysisGenProcess;
    }

    public final int getHoursAfter() {
        return this.hoursAfter;
    }

    public final int getMinutesAfter() {
        return this.minutesAfter;
    }

    public final int getTimeRangeUnit() {
        return this.timeRangeUnit;
    }

    public final String getTimeRangeUnitName() {
        return Grib2ProductDefinitionSection.getTimeRangeUnitName(this.timeRangeUnit);
    }

    public static String getTimeRangeUnitName(int timeRangeUnit) {
        switch (timeRangeUnit) {
            case 0: {
                return "minutes";
            }
            case 1: {
                return "hours";
            }
            case 2: {
                return "days";
            }
            case 3: {
                return "months";
            }
            case 4: {
                return "years";
            }
            case 5: {
                return "decade";
            }
            case 6: {
                return "normal";
            }
            case 7: {
                return "century";
            }
            case 10: {
                return "3hours";
            }
            case 11: {
                return "6hours";
            }
            case 12: {
                return "12hours";
            }
            case 13: {
                return "secs";
            }
        }
        return "unknown";
    }

    public final int getForecastTime() {
        return this.forecastTime;
    }

    public static String getTypeSurfaceName(int id) {
        switch (id) {
            case 0: {
                return "";
            }
            case 1: {
                return "Ground or water surface";
            }
            case 2: {
                return "Cloud base level";
            }
            case 3: {
                return "Level of cloud tops";
            }
            case 4: {
                return "Level of 0o C isotherm";
            }
            case 5: {
                return "Level of adiabatic condensation lifted from the surface";
            }
            case 6: {
                return "Maximum wind level";
            }
            case 7: {
                return "Tropopause";
            }
            case 8: {
                return "Nominal top of the atmosphere";
            }
            case 9: {
                return "Sea bottom";
            }
            case 20: {
                return "Isothermal level";
            }
            case 100: {
                return "Isobaric surface";
            }
            case 101: {
                return "Mean sea level";
            }
            case 102: {
                return "Specific altitude above mean sea level";
            }
            case 103: {
                return "Specified height level above ground";
            }
            case 104: {
                return "Sigma level";
            }
            case 105: {
                return "Hybrid level";
            }
            case 106: {
                return "Depth below land surface";
            }
            case 107: {
                return "Isentropic 'theta' level";
            }
            case 108: {
                return "Level at specified pressure difference from ground to level";
            }
            case 109: {
                return "Potential vorticity surface";
            }
            case 111: {
                return "Eta level";
            }
            case 117: {
                return "Mixed layer depth";
            }
            case 160: {
                return "Depth below sea level";
            }
            case 200: {
                return "Entire atmosphere layer";
            }
            case 201: {
                return "Entire ocean layer";
            }
            case 204: {
                return "Highest tropospheric freezing level";
            }
            case 206: {
                return "Grid scale cloud bottom level";
            }
            case 207: {
                return "Grid scale cloud top level";
            }
            case 209: {
                return "Boundary layer cloud bottom level";
            }
            case 210: {
                return "Boundary layer cloud top level";
            }
            case 211: {
                return "Boundary layer cloud layer";
            }
            case 212: {
                return "Low cloud bottom level";
            }
            case 213: {
                return "Low cloud top level";
            }
            case 214: {
                return "Low cloud layer";
            }
            case 215: {
                return "Cloud ceiling";
            }
            case 220: {
                return "Planetary Boundary Layer";
            }
            case 221: {
                return "Layer Between Two Hybrid Levels";
            }
            case 222: {
                return "Middle cloud bottom level";
            }
            case 223: {
                return "Middle cloud top level";
            }
            case 224: {
                return "Middle cloud layer";
            }
            case 232: {
                return "High cloud bottom level";
            }
            case 233: {
                return "High cloud top level";
            }
            case 234: {
                return "High cloud layer";
            }
            case 235: {
                return "Ocean isotherm level";
            }
            case 236: {
                return "Layer between two depths below ocean surface";
            }
            case 237: {
                return "Bottom of ocean mixed layer";
            }
            case 238: {
                return "Bottom of ocean isothermal layer";
            }
            case 239: {
                return "Layer Ocean Surface and 26C Ocean Isothermal Level";
            }
            case 240: {
                return "Ocean Mixed Layer";
            }
            case 241: {
                return "Ordered Sequence of Data";
            }
            case 242: {
                return "Convective cloud bottom level";
            }
            case 243: {
                return "Convective cloud top level";
            }
            case 244: {
                return "Convective cloud layer";
            }
            case 245: {
                return "Lowest level of the wet bulb zero";
            }
            case 246: {
                return "Maximum equivalent potential temperature level";
            }
            case 247: {
                return "Equilibrium level";
            }
            case 248: {
                return "Shallow convective cloud bottom level";
            }
            case 249: {
                return "Shallow convective cloud top level";
            }
            case 251: {
                return "Deep convective cloud bottom level";
            }
            case 252: {
                return "Deep convective cloud top level";
            }
            case 253: {
                return "Lowest bottom level of supercooled liquid water layer";
            }
            case 254: {
                return "Highest top level of supercooled liquid water layer";
            }
            case 255: {
                return "Missing";
            }
        }
        return "Unknown=" + id;
    }

    public static String getTypeSurfaceNameShort(int id) {
        switch (id) {
            case 0: {
                return "";
            }
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "pressure";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 160: {
                return "depth_below_sea";
            }
            case 200: {
                return "entire_atmosphere";
            }
            case 201: {
                return "entire_ocean";
            }
            case 204: {
                return "highest_tropospheric_freezing";
            }
            case 206: {
                return "grid_scale_cloud_bottom";
            }
            case 207: {
                return "grid_scale_cloud_top";
            }
            case 209: {
                return "boundary_layer_cloud_bottom";
            }
            case 210: {
                return "boundary_layer_cloud_top";
            }
            case 211: {
                return "boundary_layer_cloud";
            }
            case 212: {
                return "low_cloud_bottom";
            }
            case 213: {
                return "low_cloud_top";
            }
            case 214: {
                return "low_cloud";
            }
            case 215: {
                return "cloud_ceiling";
            }
            case 220: {
                return "planetary_boundary";
            }
            case 221: {
                return "between_two_hybrids";
            }
            case 222: {
                return "middle_cloud_bottom";
            }
            case 223: {
                return "middle_cloud_top";
            }
            case 224: {
                return "middle_cloud";
            }
            case 232: {
                return "high_cloud_bottom";
            }
            case 233: {
                return "high_cloud_top";
            }
            case 234: {
                return "high_cloud";
            }
            case 235: {
                return "ocean_isotherm";
            }
            case 236: {
                return "layer_between_two_depths_below_ocean";
            }
            case 237: {
                return "bottom_of_ocean_mixed";
            }
            case 238: {
                return "bottom_of_ocean_isothermal";
            }
            case 239: {
                return "ocean_surface_and_26C_isothermal";
            }
            case 240: {
                return "ocean_mixed";
            }
            case 241: {
                return "ordered_sequence_of_data";
            }
            case 242: {
                return "convective_cloud_bottom";
            }
            case 243: {
                return "convective_cloud_top";
            }
            case 244: {
                return "convective_cloud";
            }
            case 245: {
                return "lowest_level_of_the_wet_bulb_zero";
            }
            case 246: {
                return "maximum_equivalent_potential_temperature";
            }
            case 247: {
                return "equilibrium";
            }
            case 248: {
                return "shallow_convective_cloud_bottom";
            }
            case 249: {
                return "shallow_convective_cloud_top";
            }
            case 251: {
                return "deep_convective_cloud_bottom";
            }
            case 252: {
                return "deep_convective_cloud_top";
            }
            case 253: {
                return "lowest_level_water_layer";
            }
            case 254: {
                return "highest_level_water_layer";
            }
            case 255: {
                return "missing";
            }
        }
        return "Unknown" + id;
    }

    public static String getTypeSurfaceUnit(int id) {
        switch (id) {
            case 20: {
                return "K";
            }
            case 100: {
                return "Pa";
            }
            case 102: {
                return "m";
            }
            case 103: {
                return "m";
            }
            case 106: {
                return "m";
            }
            case 107: {
                return "K";
            }
            case 108: {
                return "Pa";
            }
            case 109: {
                return "K m2 kg-1 s-1";
            }
            case 117: {
                return "m";
            }
            case 160: {
                return "m";
            }
            case 235: {
                return "C 0.1";
            }
            case 237: {
                return "m";
            }
            case 238: {
                return "m";
            }
        }
        return "";
    }

    public final int getTypeFirstFixedSurface() {
        return this.typeFirstFixedSurface;
    }

    public final String getTypeFirstFixedSurfaceName() {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(this.typeFirstFixedSurface);
    }

    public final float getValueFirstFixedSurface() {
        return this.FirstFixedSurfaceValue;
    }

    public final int getTypeSecondFixedSurface() {
        return this.typeSecondFixedSurface;
    }

    public final String getTypeSecondFixedSurfaceName() {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(this.typeSecondFixedSurface);
    }

    public final float getValueSecondFixedSurface() {
        return this.SecondFixedSurfaceValue;
    }

    public final Date getEndTI() {
        return this.endTI;
    }

    public final int getTimeRanges() {
        return this.timeRanges;
    }

    public final int[] getTimeIncrement() {
        return this.timeIncrement;
    }

    public final int getStatProcess(int tr) {
        return this.timeIncrement[tr * 6];
    }

    public final int getTimeType(int tr) {
        return this.timeIncrement[tr * 6 + 1];
    }

    public final int getTimeUnit(int tr) {
        return this.timeIncrement[tr * 6 + 2];
    }

    public final int getLenTimeRange(int tr) {
        return this.timeIncrement[tr * 6 + 3];
    }

    public final int getIndicatorTU(int tr) {
        return this.timeIncrement[tr * 6 + 4];
    }

    public final int getTimeIncrement(int tr) {
        return this.timeIncrement[tr * 6 + 5];
    }

    public final int getNumberForecasts() {
        return this.numberForecasts;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getPdsData() {
        return this.pdsData;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        raf.skipBytes(Integer.parseInt(args[1]));
        Grib2ProductDefinitionSection pds = new Grib2ProductDefinitionSection(raf);
        Grib2PDSVariables gpv = new Grib2PDSVariables(pds.getPdsData());
        ps.println("Section = " + gpv.getSection());
        ps.println("Length = " + gpv.getLength());
        ps.println("ProductDefinition = " + gpv.getProductDefinition());
        assert (pds.length == gpv.getLength());
        assert (pds.section == gpv.getSection());
        assert (pds.coordinates == gpv.getCoordinates());
        assert (pds.productDefinition == gpv.getProductDefinition());
        assert (pds.parameterCategory == gpv.getParameterCategory());
        assert (pds.parameterNumber == gpv.getParameterNumber());
        if (pds.productDefinition < 20) {
            assert (pds.typeGenProcess == gpv.getTypeGenProcess());
            assert (pds.backGenProcess == gpv.getBackGenProcess());
            assert (pds.analysisGenProcess == gpv.getAnalysisGenProcess());
            assert (pds.hoursAfter == gpv.getHoursAfter());
            assert (pds.minutesAfter == gpv.getMinutesAfter());
            assert (pds.timeRangeUnit == gpv.getTimeRangeUnit());
            assert (pds.forecastTime == gpv.getForecastTime());
            assert (pds.typeFirstFixedSurface == gpv.getTypeFirstFixedSurface());
            assert (pds.FirstFixedSurfaceValue == gpv.getValueFirstFixedSurface());
            assert (pds.typeSecondFixedSurface == gpv.getTypeSecondFixedSurface());
            assert (pds.SecondFixedSurfaceValue == gpv.getValueSecondFixedSurface());
        }
        if (pds.productDefinition == 1 || pds.productDefinition == 11) {
            assert (pds.typeEnsemble == gpv.getType());
            assert (pds.perturbNumber == gpv.getPerturbation());
            assert (pds.numberForecasts == gpv.getNumberForecasts());
        } else if (pds.productDefinition == 2) {
            assert (pds.typeEnsemble == gpv.getType());
            assert (pds.numberForecasts == gpv.getNumberForecasts());
        } else if (pds.productDefinition == 5) {
            assert (pds.typeEnsemble == gpv.getType());
            assert (pds.lowerLimit == gpv.getValueLowerLimit());
            assert (pds.upperLimit == gpv.getValueUpperLimit());
        } else if (pds.productDefinition == 9) {
            assert (pds.typeEnsemble == gpv.getType());
            assert (pds.numberForecasts == gpv.getNumberForecasts());
            assert (pds.lowerLimit == gpv.getValueLowerLimit());
            assert (pds.upperLimit == gpv.getValueUpperLimit());
        }
    }
}

