/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribNumbers;
import ucar.grib.GribReadIndex;
import ucar.grib.GribReadTextIndex;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndexExtender;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.unidata.io.RandomAccessFile;

public class Grib2WriteIndex {
    private static boolean debugTiming = false;
    private static boolean verbose = false;
    public static int indexRafBufferSize = 250;
    private static boolean maintainIndexType = true;
    private final Calendar calendar = Calendar.getInstance();

    public Grib2WriteIndex() {
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex writeGribIndex(File grib, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        raf.order(0);
        return this.writeGribIndex(grib, gbxName, raf, makeIndex);
    }

    public final GridIndex writeGribIndex(File grib, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName, false)));
        GridIndex gindex = this.writeGribIndex(raf, grib.lastModified(), out, makeIndex);
        out.close();
        return gindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        GridIndex index = makeIndex ? new GridIndex() : null;
        try {
            inputRaf.seek(0L);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 7.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            int decimalScale = -9999;
            boolean bmsExists = false;
            List<Grib2Product> products = g2i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" basetime " + dateFormat.format(baseTime));
                    out.writeUTF(sb.toString());
                    if (makeIndex) {
                        String[] split = sb.toString().split("\\s");
                        for (int j = 0; j < split.length; j += 2) {
                            index.addGlobalAttribute(split[j], split[j + 1]);
                        }
                    }
                    out.writeInt(products.size());
                    if (verbose) {
                        System.out.println("Index created with number records =" + products.size());
                    }
                }
                out.writeInt(pds.getProductDefinition());
                out.writeInt(product.getDiscipline());
                out.writeInt(pds.getParameterCategory());
                out.writeInt(pds.getParameterNumber());
                out.writeInt(pds.getTypeGenProcessNumeric());
                out.writeInt(pds.getTypeFirstFixedSurface());
                out.writeFloat(pds.getValueFirstFixedSurface());
                out.writeInt(pds.getTypeSecondFixedSurface());
                out.writeFloat(pds.getValueSecondFixedSurface());
                out.writeLong(product.getRefTime());
                out.writeInt(pds.getForecastTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                if (makeIndex) {
                    GribGridRecord gr = new GribGridRecord(this.calendar, pds.getProductDefinition(), product.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber(), pds.getTypeGenProcessNumeric(), pds.getTypeFirstFixedSurface(), pds.getValueFirstFixedSurface(), pds.getTypeSecondFixedSurface(), pds.getTypeSecondFixedSurface(), product.getBaseTime(), pds.getForecastTime(), product.getGDSkeyInt(), product.getGdsOffset(), product.getPdsOffset(), decimalScale, bmsExists, id.getCenter_id(), id.getSubcenter_id(), id.getLocal_table_version());
                    index.addGridRecord(gr);
                }
                ++count;
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            for (String key : gdsHM.keySet()) {
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                String gdsStr = this.printGDS(key, gds, out);
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = new GribGridDefRecord(gdsStr);
                index.addHorizCoordSys(ggdr);
            }
            out.writeUTF("End");
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return index;
    }

    public final GridIndex extendGribIndex(File grib, File gbx, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        raf.order(0);
        return this.extendGribIndex(grib, gbx, gbxName, raf, makeIndex);
    }

    public final GridIndex extendGribIndex(File grib, File gbx, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        GridIndex oldIndex = new GribReadIndex().open(gbxName);
        Map<String, String> attr = oldIndex.getGlobalAttributes();
        double version = Double.parseDouble(attr.get("index_version"));
        if (maintainIndexType && version < 7.0) {
            new Grib2IndexExtender().extendIndex(raf, gbx, null);
            return new GribReadTextIndex().open(gbxName);
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName + ".tmp", false)));
        GridIndex gindex = this.extendGribIndex(oldIndex, raf, grib.lastModified(), out, makeIndex);
        if (out.size() == 8) {
            out.close();
            File tidx = new File(gbxName + ".tmp");
            tidx.delete();
            gbx.setLastModified(grib.lastModified() + 1000L);
        } else {
            out.close();
            gbx.delete();
            File tidx = new File(gbxName + ".tmp");
            tidx.renameTo(gbx);
        }
        return gindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(GridIndex oldIndex, RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2ExtendIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        List<GridRecord> oldRecords = oldIndex.getGridRecords();
        GridRecord gr = oldRecords.get(oldRecords.size() - 1);
        GribGridRecord ggr = (GribGridRecord)gr;
        GridIndex index = makeIndex ? new GridIndex() : null;
        try {
            inputRaf.seek(ggr.offset2);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 7.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            int decimalScale = -9999;
            boolean bmsExists = false;
            List<Grib2Product> products = g2i.getProducts();
            if (products.size() == 0) {
                index = null;
                GridIndex gridIndex = oldIndex;
                return gridIndex;
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" baseTime " + dateFormat.format(baseTime));
                    out.writeUTF(sb.toString());
                    if (makeIndex) {
                        String[] split = sb.toString().split("\\s");
                        for (int j = 0; j < split.length; j += 2) {
                            index.addGlobalAttribute(split[j], split[j + 1]);
                        }
                    }
                    out.writeInt(products.size() + oldIndex.getGridCount());
                    if (verbose) {
                        System.out.println("Index extended with old new records " + oldIndex.getGridCount() + "  " + products.size());
                    }
                    for (GridRecord ogr : oldRecords) {
                        GribGridRecord oggr = (GribGridRecord)ogr;
                        out.writeInt(oggr.productType);
                        out.writeInt(oggr.discipline);
                        out.writeInt(oggr.category);
                        out.writeInt(oggr.paramNumber);
                        out.writeInt(oggr.typeGenProcess);
                        out.writeInt(oggr.levelType1);
                        out.writeFloat((float)oggr.levelValue1);
                        out.writeInt(oggr.levelType2);
                        out.writeFloat((float)oggr.levelValue2);
                        out.writeLong(oggr.refTime.getTime());
                        out.writeInt(oggr.forecastTime);
                        out.writeInt(oggr.gdsKey);
                        out.writeLong(oggr.offset1);
                        out.writeLong(oggr.offset2);
                        if (makeIndex) {
                            gr = new GribGridRecord(this.calendar, oggr.productType, oggr.discipline, oggr.category, oggr.paramNumber, oggr.typeGenProcess, oggr.levelType1, (float)oggr.levelValue1, oggr.levelType2, (float)oggr.levelValue2, oggr.refTime, oggr.forecastTime, oggr.gdsKey, oggr.offset1, oggr.offset2, decimalScale, bmsExists, oggr.center, oggr.subCenter, oggr.table);
                            index.addGridRecord(gr);
                        }
                        ++count;
                    }
                }
                out.writeInt(pds.getProductDefinition());
                out.writeInt(product.getDiscipline());
                out.writeInt(pds.getParameterCategory());
                out.writeInt(pds.getParameterNumber());
                out.writeInt(pds.getTypeGenProcessNumeric());
                out.writeInt(pds.getTypeFirstFixedSurface());
                out.writeFloat(pds.getValueFirstFixedSurface());
                out.writeInt(pds.getTypeSecondFixedSurface());
                out.writeFloat(pds.getValueSecondFixedSurface());
                out.writeLong(product.getRefTime());
                out.writeInt(pds.getForecastTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                if (makeIndex) {
                    gr = new GribGridRecord(this.calendar, pds.getProductDefinition(), product.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber(), pds.getTypeGenProcessNumeric(), pds.getTypeFirstFixedSurface(), pds.getValueFirstFixedSurface(), pds.getTypeSecondFixedSurface(), pds.getValueSecondFixedSurface(), product.getBaseTime(), pds.getForecastTime(), product.getGDSkeyInt(), product.getGdsOffset(), product.getPdsOffset(), decimalScale, bmsExists, id.getCenter_id(), id.getSubcenter_id(), id.getLocal_table_version());
                    index.addGridRecord(gr);
                }
                ++count;
            }
            ArrayList<String> alreadySeen = new ArrayList<String>();
            List<GridDefRecord> gdrList = oldIndex.getHorizCoordSys();
            for (GridDefRecord gdr : gdrList) {
                String paramsValues = gdr.getParamsValues();
                out.writeUTF(paramsValues);
                alreadySeen.add(gdr.getParam("GDSkey"));
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = (GribGridDefRecord)gdr;
                index.addHorizCoordSys(ggdr);
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            for (String key : gdsHM.keySet()) {
                if (alreadySeen.contains(key)) continue;
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                String gdsStr = this.printGDS(key, gds, out);
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = new GribGridDefRecord(gdsStr);
                index.addHorizCoordSys(ggdr);
                String[] split = gdsStr.split("\\t");
                for (int i = 0; i < split.length; i += 2) {
                    ggdr.addParam(split[i], split[i + 1]);
                }
            }
            out.writeUTF("End");
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return index;
    }

    public String printGDS(String key, Grib2GridDefinitionSection gds, DataOutputStream out) throws IOException {
        String winds;
        StringBuilder sb = new StringBuilder();
        sb.append("GDSkey\t" + key);
        sb.append("\tgrid_type\t" + gds.getGdtn());
        sb.append("\tgrid_name\t" + gds.getName());
        String string = winds = GribNumbers.isBitSet(gds.getResolution(), 8) ? "Relative" : "True";
        if ((gds.getGdtn() < 50 || gds.getGdtn() > 53) && gds.getGdtn() != 100 && gds.getGdtn() != 120 && gds.getGdtn() != 1200) {
            sb.append("\tgrid_shape_code\t" + gds.getShape());
            sb.append("\tgrid_shape\t" + gds.getShapeName());
            if (gds.getShape() < 2 || gds.getShape() == 6) {
                sb.append("\tgrid_radius_spherical_earth\t" + gds.getEarthRadius());
            } else if (gds.getShape() > 1 && gds.getShape() < 5) {
                sb.append("\tgrid_major_axis_earth\t" + gds.getMajorAxis());
                sb.append("\tgrid_minor_axis_earth\t" + gds.getMinorAxis());
            }
        }
        if (gds.getOlon() == 0) {
            sb.append("\tQuasi\tfalse");
        } else {
            sb.append("\tQuasi\ttrue");
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                if (gds.getGdtn() == 1) {
                    sb.append("\tSpLat\t" + gds.getSpLat());
                    sb.append("\tSpLon\t" + gds.getSpLon());
                    sb.append("\tRotationAngle\t" + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 2) {
                    sb.append("\tpLat\t" + gds.getPoleLat());
                    sb.append("\tpLon\t" + gds.getPoleLon());
                    sb.append("\tStretchingFactor\t" + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 3) break;
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                sb.append("\tRotationAngle\t" + gds.getRotationangle());
                sb.append("\tpLat\t" + gds.getPoleLat());
                sb.append("\tpLon\t" + gds.getPoleLon());
                sb.append("\tStretchingFactor\t" + gds.getFactor());
                break;
            }
            case 10: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tLaD\t" + gds.getLad());
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tBasicAngle\t" + gds.getAngle());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                break;
            }
            case 20: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tLaD\t" + gds.getLad());
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                break;
            }
            case 30: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tLaD\t" + gds.getLad());
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                sb.append("\tLatin1\t" + gds.getLatin1());
                sb.append("\tLatin2\t" + gds.getLatin2());
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tStretchingFactor\t" + gds.getFactor());
                sb.append("\tNumberParallels\t" + gds.getN());
                if (gds.getGdtn() == 41) {
                    sb.append("\tSpLat\t" + gds.getSpLat());
                    sb.append("\tSpLon\t" + gds.getSpLon());
                    sb.append("\tRotationAngle\t" + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 42) {
                    sb.append("\tpLat\t" + gds.getPoleLat());
                    sb.append("\tpLon\t" + gds.getPoleLon());
                    sb.append("\tStretchingFactor\t" + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 43) break;
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                sb.append("\tRotationAngle\t" + gds.getRotationangle());
                sb.append("\tpLat\t" + gds.getPoleLat());
                sb.append("\tpLon\t" + gds.getPoleLon());
                sb.append("\tStretchingFactor\t" + gds.getFactor());
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                sb.append("\tJ\t" + gds.getJ());
                sb.append("\tK\t" + gds.getK());
                sb.append("\tM\t" + gds.getM());
                sb.append("\tMethodNorm\t" + gds.getMethod());
                sb.append("\tModeOrder\t" + gds.getMode());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                if (gds.getGdtn() == 51) {
                    sb.append("\tSpLat\t" + gds.getSpLat());
                    sb.append("\tSpLon\t" + gds.getSpLon());
                    sb.append("\tRotationAngle\t" + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 52) {
                    sb.append("\tpLat\t" + gds.getPoleLat());
                    sb.append("\tpLon\t" + gds.getPoleLon());
                    sb.append("\tStretchingFactor\t" + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 53) break;
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                sb.append("\tRotationAngle\t" + gds.getRotationangle());
                sb.append("\tpLat\t" + gds.getPoleLat());
                sb.append("\tpLon\t" + gds.getPoleLon());
                sb.append("\tStretchingFactor\t" + gds.getFactor());
                break;
            }
            case 90: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLap\t" + gds.getLap());
                sb.append("\tLop\t" + gds.getLop());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tXp\t" + gds.getXp());
                sb.append("\tYp\t" + gds.getYp());
                sb.append("\tAngle\t" + gds.getAngle());
                sb.append("\tNr\t" + gds.getAltitude());
                sb.append("\tXo\t" + gds.getXo());
                sb.append("\tYo\t" + gds.getYo());
                break;
            }
            case 100: {
                sb.append("\tExponent2Intervals\t" + gds.getN2());
                sb.append("\tExponent3Intervals\t" + gds.getN3());
                sb.append("\tNumberIntervals\t" + gds.getNi());
                sb.append("\tNumberDiamonds\t" + gds.getNd());
                sb.append("\tpLat\t" + gds.getPoleLat());
                sb.append("\tpLon\t" + gds.getPoleLon());
                sb.append("\tGridPointPosition\t" + gds.getPosition());
                sb.append("\tNumberOrderDiamonds\t" + gds.getOrder());
                sb.append("\tNumberParallels\t" + gds.getN());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                break;
            }
            case 110: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                sb.append("\tWinds\t" + winds);
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                break;
            }
            case 120: {
                sb.append("\tNumberDataBins\t" + gds.getNb());
                sb.append("\tNumberRadials\t" + gds.getNr());
                sb.append("\tNumberPointsParallel\t" + gds.getNx());
                sb.append("\tLa1\t" + gds.getLa1());
                sb.append("\tLo1\t" + gds.getLo1());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                sb.append("\tOffsetFromOrigin\t" + gds.getDstart());
                break;
            }
            case 204: {
                sb.append("\tNx\t" + gds.getNx());
                sb.append("\tNy\t" + gds.getNy());
                sb.append("\tResCompFlag\t" + gds.getResolution());
                sb.append("\tWinds\t" + winds);
                sb.append("\tgrid_units\t" + gds.getGrid_units());
                break;
            }
            default: {
                out.writeUTF("\tUnknown Grid Type\t" + gds.getGdtn());
            }
        }
        out.writeUTF(sb.toString());
        return sb.toString();
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default name + .gbx");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
    }

    public static void main(String[] args) throws IOException {
        Grib2WriteIndex indexer = new Grib2WriteIndex();
        debugTiming = true;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib2WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        String gribName = args[0];
        File grib = new File(args[0]);
        long rafLastModified = grib.lastModified();
        if (args.length == 2) {
            String gbxName = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            File gbx = new File(gbxName);
            if (gbx.exists() && gbx.lastModified() > rafLastModified) {
                return;
            }
            if (gbx.exists()) {
                indexer.extendGribIndex(grib, gbx, gribName, gbxName, false);
            } else {
                indexer.writeGribIndex(grib, gribName, gbxName, false);
            }
        } else if (args.length == 1) {
            indexer.writeGribIndex(grib, gribName, gribName + ".gbx", false);
        }
    }
}

