/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import ucar.grib.Diff;
import ucar.grib.grib2.Grib2GetData;

public final class TestGrib2Data
extends TestCase {
    private final boolean reset = false;
    private String dataPath;
    private String testPath;
    private Diff d;

    protected final void setUp() {
        this.dataPath = "/upc/share/testdata/grid/grib/grib2/data/";
        this.testPath = "/upc/share/testdata/grid/grib/grib2/test/";
        this.d = new Diff();
    }

    public static Test suite() {
        return new TestSuite(TestGrib2Data.class);
    }

    public final void testData() {
        String[] arg = new String[4];
        System.out.println("\nTesting data extraction from gfs.000192 ");
        arg[0] = this.dataPath + "gfs.000192";
        arg[1] = "37";
        arg[2] = "130428";
        arg[3] = "gfs.000192Data";
        Grib2GetData.main(arg);
        this.d.doDiff(this.testPath + "gfs.000192Data.test", "gfs.000192Data");
        File f = new File("gfs.000192Data");
        f.delete();
        System.out.println("\nTesting data extraction from ndfd.wmo");
        arg[0] = this.dataPath + "ndfd.wmo";
        arg[1] = "498193";
        arg[2] = "498274";
        arg[3] = "NdfdData";
        Grib2GetData.main(arg);
        this.d.doDiff(this.testPath + "NdfdData.test", "NdfdData");
        f = new File("NdfdData");
        f.delete();
        System.out.println("\nTesting data extraction from ds.mint.bin");
        arg[0] = this.dataPath + "ds.mint.bin";
        arg[1] = "117";
        arg[2] = "198";
        arg[3] = "ds.mint.binData";
        Grib2GetData.main(arg);
        this.d.doDiff(this.testPath + "ds.mint.binData.test", "ds.mint.binData");
        f = new File("ds.mint.binData");
        f.delete();
        System.out.println("\nTesting data extraction from AVN.5deg.wmo");
        arg[0] = this.dataPath + "AVN.5deg.wmo";
        arg[1] = "22575268";
        arg[2] = "22575340";
        arg[3] = "AVN.5deg.data";
        Grib2GetData.main(arg);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "AVN.5degData.test", "AVN.5deg.data");
        f = new File("AVN.5deg.data");
        f.delete();
        System.out.println("\nTesting data extraction from CLDGRIB2.2005040905");
        arg[0] = this.dataPath + "CLDGRIB2.2005040905";
        arg[1] = "193485";
        arg[2] = "193566";
        arg[3] = "CLDGRIB2";
        Grib2GetData.main(arg);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "CLDGRIB2Data.test", "CLDGRIB2");
        f = new File("CLDGRIB2");
        f.delete();
        System.out.println("\nTesting data extraction from z_tigge_c_ecmf_20060827000000_0078_pv_glob_test.grib2");
        arg[0] = this.dataPath + "z_tigge_c_ecmf_20060827000000_0078_pv_glob_test.grib2";
        arg[1] = "42";
        arg[2] = "914";
        arg[3] = "ztigge.data";
        Grib2GetData.main(arg);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "ztigge.data.test", "ztigge.data");
        f = new File("ztigge.data");
        f.delete();
        System.out.println("\nTesting Jpeg2000 data extraction from 0905712000000");
        arg[0] = this.dataPath + "0905712000000";
        arg[1] = "882470";
        arg[2] = "882551";
        arg[3] = "0905712000000.data";
        Grib2GetData.main(arg);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "0905712000000.data.test", "0905712000000.data");
        f = new File("0905712000000.data");
        f.delete();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGrib2Data.suite());
    }
}

