/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import ucar.grib.GribChecker;
import ucar.unidata.io.RandomAccessFile;

public final class TestGrib2Edition
extends TestCase {
    private String dataPath;
    private String testPath;

    protected final void setUp() {
        this.dataPath = "/upc/share/testdata/grid/grib/grib2/data/";
        this.testPath = "/upc/share/testdata/grid/grib/grib2/test/";
    }

    public static Test suite() {
        return new TestSuite(TestGrib2Edition.class);
    }

    public final void testEdition() throws IOException {
        int edition = 0;
        System.out.println("Testing GRIB edition of ndfd.wmo");
        RandomAccessFile raf = new RandomAccessFile(this.dataPath + "ndfd.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib2Edition.assertEquals((String)"ndfd.wmo edition", (int)2, (int)edition);
        System.out.println("Testing GRIB edition of eta2.wmo");
        raf = new RandomAccessFile(this.dataPath + "eta2.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib2Edition.assertEquals((String)"eta2.wmo edition", (int)2, (int)edition);
        System.out.println("Testing GRIB edition of AVN.5deg.wmo");
        raf = new RandomAccessFile(this.dataPath + "AVN.5deg.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib2Edition.assertEquals((String)"eta2.wmo edition", (int)2, (int)edition);
        System.out.println("Testing GRIB edition of CLDGRIB2.2005040905");
        raf = new RandomAccessFile(this.dataPath + "CLDGRIB2.2005040905", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib2Edition.assertEquals((String)"eta2.wmo edition", (int)2, (int)edition);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGrib2Edition.suite());
    }
}

