/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import ucar.grib.grib2.Grib2Data;
import ucar.unidata.io.RandomAccessFile;

public final class TestGrib2GetData {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileContainingData> ");
        System.out.println("<OffsetToGds> obtained from Grib2Indexer program");
        System.out.println("<OffsetToPds> obtained from Grib2Indexer program");
        System.out.println("<output file>");
        System.out.println();
        System.out.println("java -Xmx256m ucar/grib/grib2/" + className + " <GribFileContainingData> <OffsetToGds> <OffsetToPds>");
        System.exit(0);
    }

    public static void main(String[] args) {
        TestGrib2GetData func = new TestGrib2GetData();
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            String line;
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            long GdsOffset = 0L;
            long PdsOffset = 0L;
            if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
                raf.order(0);
            } else {
                System.exit(0);
            }
            if (args.length == 4) {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[3], false)));
            }
            Grib2Data g2d = new Grib2Data(raf);
            InputStream ios = TestGrib2GetData.open(args[0] + ".gbx");
            long start = System.currentTimeMillis();
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
            while ((line = dataIS.readLine()) != null && line.length() != 0 && !line.startsWith("--")) {
            }
            while ((line = dataIS.readLine()) != null && line.length() != 0 && !line.startsWith("--")) {
                StringTokenizer stoke = new StringTokenizer(line);
                String productType = stoke.nextToken();
                String discipline = stoke.nextToken();
                String category = stoke.nextToken();
                String param = stoke.nextToken();
                String typeGenProcess = stoke.nextToken();
                String levelType1 = stoke.nextToken();
                String levelValue1 = stoke.nextToken();
                String levelType2 = stoke.nextToken();
                String levelValue2 = stoke.nextToken();
                String refTime = stoke.nextToken();
                String foreTime = stoke.nextToken();
                String gdsKey = stoke.nextToken();
                GdsOffset = Long.parseLong(stoke.nextToken());
                float[] data = g2d.getData(GdsOffset, PdsOffset = Long.parseLong(stoke.nextToken()));
                if (data != null) {
                    System.err.println("OK " + line);
                    continue;
                }
                System.err.println("No data returned " + line);
            }
            raf.close();
            ps.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... End of GribGetDataCheck");
    }

    public static final InputStream open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }
}

