/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import ucar.grib.Diff;
import ucar.grib.grib2.Grib2Indexer;

public final class TestGrib2Indexer
extends TestCase {
    private final boolean reset = false;
    private String dataPath;
    private String testPath;
    private Diff d;

    protected final void setUp() {
        this.dataPath = "/upc/share/testdata/grid/grib/grib2/data/";
        this.testPath = "/upc/share/testdata/grid/grib/grib2/test/";
        this.d = new Diff();
    }

    public static Test suite() {
        return new TestSuite(TestGrib2Indexer.class);
    }

    public final void testIndex() throws IOException {
        System.out.println("\nTesting indexing of ndfd.wmo");
        System.out.println("var created will be different");
        String[] args = new String[]{this.dataPath + "ndfd.wmo", "NdfdIndex"};
        Grib2Indexer.main(args);
        this.d.doDiff(this.testPath + "NdfdIndex.gbx", "NdfdIndex.gbx");
        File f = new File("NdfdIndex.gbx");
        f.delete();
        System.out.println("\nTesting indexing of AVN.5deg.wmo");
        System.out.println("var created will be different");
        args[0] = this.dataPath + "AVN.5deg.wmo";
        args[1] = "AVN.5deg.wmo";
        Grib2Indexer.main(args);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "AVN.5deg.wmo.gbx", "AVN.5deg.wmo.gbx");
        f = new File("AVN.5deg.wmo.gbx");
        f.delete();
        System.out.println("\nTesting indexing of CLDGRIB2.2005040905");
        System.out.println("var created will be different");
        args[0] = this.dataPath + "CLDGRIB2.2005040905";
        args[1] = "CLDGRIB2.2005040905";
        Grib2Indexer.main(args);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "CLDGRIB2.2005040905.gbx", "CLDGRIB2.2005040905.gbx");
        f = new File("CLDGRIB2.2005040905.gbx");
        f.delete();
        System.out.println("\nTesting indexing of Global_1p0deg_Ensemble.grib2");
        System.out.println("var created will be different");
        args[0] = this.dataPath + "Global_1p0deg_Ensemble.grib2";
        args[1] = "Global_1p0deg_Ensemble.grib2";
        Grib2Indexer.main(args);
        this.d = new Diff();
        this.d.doDiff(this.testPath + "Global_1p0deg_Ensemble.grib2.gbx", "Global_1p0deg_Ensemble.grib2.gbx");
        f = new File("Global_1p0deg_Ensemble.grib2.gbx");
        f.delete();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGrib2Indexer.suite());
    }
}

