/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.grib2.Grib2Indexer;
import ucar.grib.grib2.Grib2WriteIndex;

public class TestGrib2WriteIndex {
    private void indexer(String type, int stop, String sDir) throws IOException {
        long start = System.currentTimeMillis();
        Date now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... Start of TestGrib2WriteIndex");
        File dir = new File(sDir);
        int count = 0;
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + File.separator + dir.getName());
            for (String child : children = dir.list()) {
                if (!child.endsWith("grib2")) continue;
                if (count == stop) break;
                ++count;
                String[] args = new String[2];
                args[0] = dir + File.separator + child;
                if (type.equals("binary")) {
                    args[1] = dir + File.separator + "binary" + File.separator + child + ".gbx";
                    Grib2WriteIndex.main(args);
                    continue;
                }
                args[1] = dir + File.separator + "text" + File.separator + child + ".gbx";
                Grib2Indexer.main(args);
            }
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("Total time = " + total + " msec");
        System.out.println("Avg time = " + total / (long)count + " msec");
    }

    public static void main(String[] args) throws IOException {
        TestGrib2WriteIndex tg2wi = new TestGrib2WriteIndex();
        tg2wi.indexer(args[0], Integer.parseInt(args[1]), args[2]);
    }
}

