/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointCollectionImpl
implements PointFeatureCollection {
    protected String name;
    protected LatLonRect boundingBox;
    protected DateRange dateRange;
    protected int npts;
    protected PointFeatureIterator localIterator;

    protected PointCollectionImpl(String name) {
        this.name = name;
        this.npts = -1;
    }

    protected PointCollectionImpl(String name, LatLonRect boundingBox, DateRange dateRange, int npts) {
        this.name = name;
        this.boundingBox = boundingBox;
        this.dateRange = dateRange;
        this.npts = npts;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    public PointFeature next() throws IOException {
        return this.localIterator.next();
    }

    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureIterator(-1);
    }

    public int size() {
        return this.npts;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    public void setDateRange(DateRange range) {
        this.dateRange = range;
    }

    public void setBoundingBox(LatLonRect bb) {
        this.boundingBox = bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcBounds() throws IOException {
        if (this.dateRange != null && this.boundingBox != null && this.size() > 0) {
            return;
        }
        PointFeatureIterator iter = this.getPointFeatureIterator(-1);
        iter.setCalculateBounds(this);
        try {
            while (iter.hasNext()) {
                iter.next();
            }
            Object var3_2 = null;
            iter.finish();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            iter.finish();
            throw throwable;
        }
    }

    public void setSize(int npts) {
        this.npts = npts;
    }

    public FeatureType getCollectionFeatureType() {
        return FeatureType.POINT;
    }

    public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return new PointFeatureCollectionSubset(this, boundingBox, dateRange);
    }

    protected class PointFeatureCollectionSubset
    extends PointCollectionImpl {
        protected PointCollectionImpl from;

        public PointFeatureCollectionSubset(PointCollectionImpl from, LatLonRect filter_bb, DateRange filter_date) {
            super(from.name);
            this.from = from;
            if (filter_bb == null) {
                this.boundingBox = from.boundingBox;
            } else {
                LatLonRect latLonRect = this.boundingBox = from.boundingBox == null ? filter_bb : from.boundingBox.intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(bufferSize), this.boundingBox, this.dateRange);
        }
    }
}

