/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointIteratorAbstract
implements PointFeatureIterator {
    protected boolean calcBounds = false;
    protected PointFeatureCollection collection;
    private LatLonRect bb = null;
    private double minTime = Double.MAX_VALUE;
    private double maxTime = -1.7976931348623157E308;
    private DateUnit timeUnit;
    private int count;

    protected PointIteratorAbstract() {
    }

    public void setCalculateBounds(PointFeatureCollection collection) {
        this.calcBounds = true;
        this.collection = collection;
    }

    protected void calcBounds(PointFeature pf) {
        ++this.count;
        if (!this.calcBounds) {
            return;
        }
        if (pf == null) {
            return;
        }
        if (this.bb == null) {
            this.bb = new LatLonRect(pf.getLocation().getLatLon(), 0.001, 0.001);
        } else {
            this.bb.extend(pf.getLocation().getLatLon());
        }
        if (this.timeUnit == null) {
            this.timeUnit = pf.getTimeUnit();
        }
        double obsTime = pf.getObservationTime();
        this.minTime = Math.min(this.minTime, obsTime);
        this.maxTime = Math.max(this.maxTime, obsTime);
    }

    protected void finishCalcBounds() {
        if (!this.calcBounds) {
            return;
        }
        if (this.bb != null && this.bb.crossDateline() && this.bb.getWidth() > 350.0) {
            double lat_min = this.bb.getLowerLeftPoint().getLatitude();
            double deltaLat = this.bb.getUpperLeftPoint().getLatitude() - lat_min;
            this.bb = new LatLonRect(new LatLonPointImpl(lat_min, -180.0), deltaLat, 360.0);
        }
        if (this.collection != null) {
            if (this.collection.getBoundingBox() == null) {
                this.collection.setBoundingBox(this.bb);
            }
            DateRange dr = this.getDateRange();
            if (this.collection.getDateRange() == null && dr != null) {
                this.collection.setDateRange(dr);
            }
            if (this.collection.size() <= 0) {
                this.collection.setSize(this.count);
            }
        }
    }

    public LatLonRect getBoundingBox() {
        return this.bb;
    }

    public DateRange getDateRange() {
        if (!this.calcBounds) {
            return null;
        }
        if (this.timeUnit == null) {
            return null;
        }
        return new DateRange(this.timeUnit.makeDate(this.minTime), this.timeUnit.makeDate(this.maxTime));
    }

    public int getCount() {
        return this.count;
    }

    public static class Filter
    implements PointFeatureIterator.Filter {
        private LatLonRect filter_bb;
        private DateRange filter_date;

        public Filter(LatLonRect filter_bb, DateRange filter_date) {
            this.filter_bb = filter_bb;
            this.filter_date = filter_date;
        }

        public boolean filter(PointFeature pdata) {
            if (this.filter_date != null && !this.filter_date.included(pdata.getObservationTimeAsDate())) {
                return false;
            }
            return this.filter_bb == null || this.filter_bb.contains(pdata.getLocation().getLatitude(), pdata.getLocation().getLongitude());
        }
    }
}

