/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Formatter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.collection.CollectionManager;
import ucar.nc2.ft.point.collection.CompositePointCollection;
import ucar.nc2.ft.point.collection.CompositeStationCollection;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class CompositeDatasetFactory {
    public static final String SCHEME = "collection:";
    private static Logger log = LoggerFactory.getLogger(CompositeDatasetFactory.class);
    static boolean debug = true;

    public static FeatureDataset factory(String locationURI, File configFile, Formatter errlog) throws IOException {
        Document configDoc;
        SAXBuilder builder = new SAXBuilder();
        try {
            configDoc = builder.build(configFile);
        }
        catch (JDOMException e) {
            errlog.format("CompositeDatasetFactory failed to read config document %s err= %s %n", configFile.getPath(), e.getMessage());
            return null;
        }
        Element root = configDoc.getRootElement();
        String type = root.getChild("type").getText();
        FeatureType wantFeatureType = FeatureType.getType(type);
        String location = root.getChild("location").getText();
        String dateFormatMark = root.getChild("dateFormatMark").getText();
        Element geo = root.getChild("geospatialCoverage");
        Element northsouth = geo.getChild("northsouth");
        double latStart = CompositeDatasetFactory.readDouble(northsouth.getChild("start"), errlog);
        double latSize = CompositeDatasetFactory.readDouble(northsouth.getChild("size"), errlog);
        Element eastwest = geo.getChild("eastwest");
        double lonStart = CompositeDatasetFactory.readDouble(eastwest.getChild("start"), errlog);
        double lonSize = CompositeDatasetFactory.readDouble(eastwest.getChild("size"), errlog);
        LatLonRect llbb = new LatLonRect(new LatLonPointImpl(latStart, lonStart), latSize, lonSize);
        Element timeCoverage = root.getChild("timeCoverage");
        DateType start = CompositeDatasetFactory.readDate(timeCoverage.getChild("start"), errlog);
        DateType end = CompositeDatasetFactory.readDate(timeCoverage.getChild("end"), errlog);
        TimeDuration duration = CompositeDatasetFactory.readDuration(timeCoverage.getChild("duration"), errlog);
        DateRange dateRange = null;
        try {
            dateRange = new DateRange(start, end, duration, null);
        }
        catch (IllegalArgumentException e) {
            errlog.format(" ** warning: TimeCoverage error = %s%n", e.getMessage());
            return null;
        }
        CompositePointDataset fd = (CompositePointDataset)CompositeDatasetFactory.factory(locationURI, wantFeatureType, location + "?" + dateFormatMark, errlog);
        if (fd == null) {
            return null;
        }
        fd.setBoundingBox(llbb);
        fd.setDateRange(dateRange);
        return fd;
    }

    static double readDouble(Element elem, Formatter errlog) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            errlog.format(" ** Parse error: Bad double format %s%n", text);
            return Double.NaN;
        }
    }

    static DateType readDate(Element elem, Formatter errlog) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        String text = elem.getText();
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type);
        }
        catch (ParseException e) {
            errlog.format(" ** Parse error: Bad date format = %s%n", text);
            return null;
        }
    }

    static TimeDuration readDuration(Element elem, Formatter errlog) {
        if (elem == null) {
            return null;
        }
        String text = null;
        try {
            text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            errlog.format(" ** Parse error: Bad duration format = %s%n", text);
            return null;
        }
    }

    public static FeatureDataset factory(String location, FeatureType wantFeatureType, String wildcard, Formatter errlog) throws IOException {
        CollectionManager datasets;
        if (wildcard.startsWith(SCHEME)) {
            wildcard = wildcard.substring(SCHEME.length());
        }
        if ((datasets = CollectionManager.factory(wildcard, errlog)) == null) {
            return null;
        }
        FeatureCollection pfc = null;
        switch (wantFeatureType) {
            case POINT: {
                pfc = new CompositePointCollection(wildcard, datasets);
                break;
            }
            case STATION: {
                pfc = new CompositeStationCollection(wildcard, datasets);
                break;
            }
            default: {
                return null;
            }
        }
        return new CompositePointDataset(location, wantFeatureType, pfc, datasets);
    }

    private static class CompositePointDataset
    extends PointDatasetImpl {
        private TimedCollection datasets;
        private FeatureDatasetPoint proto;

        public CompositePointDataset(String location, FeatureType featureType, FeatureCollection pfc, TimedCollection datasets) {
            super(featureType);
            this.setLocationURI(location);
            this.setPointFeatureCollection(pfc);
            this.datasets = datasets;
            if (this.dateRange != null) {
                this.setDateRange(datasets.getDateRange());
            }
        }

        protected void setDateRange(DateRange dateRange) {
            super.setDateRange(dateRange);
        }

        protected void setBoundingBox(LatLonRect boundingBox) {
            super.setBoundingBox(boundingBox);
        }

        public NetcdfFile getNetcdfFile() {
            if (this.proto == null) {
                String loc = this.datasets.getPrototype().getLocation();
                Formatter errlog = new Formatter();
                try {
                    this.proto = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, loc, null, errlog);
                }
                catch (IOException e) {
                    log.error(errlog.toString());
                    e.printStackTrace();
                }
            }
            return this.proto.getNetcdfFile();
        }
    }
}

