/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.Station;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointStream {
    public static PointStreamProto.PointFeatureCollection encodePointFeatureCollection(String name, PointFeature pf) throws IOException {
        PointStreamProto.PointFeatureCollection.Builder builder = PointStreamProto.PointFeatureCollection.newBuilder();
        if (name == null) {
            System.out.printf("HEY%n", new Object[0]);
        }
        builder.setName(name);
        builder.setTimeUnit(pf.getTimeUnit().getUnitsString());
        StructureData sdata = pf.getData();
        StructureMembers sm = sdata.getStructureMembers();
        for (StructureMembers.Member m : sm.getMembers()) {
            PointStreamProto.Member.Builder mbuilder = PointStreamProto.Member.newBuilder();
            mbuilder.setName(m.getName());
            if (null != m.getDescription()) {
                mbuilder.setDesc(m.getDescription());
            }
            if (null != m.getUnitsString()) {
                mbuilder.setUnits(m.getUnitsString());
            }
            mbuilder.setDataType(NcStream.encodeDataType(m.getDataType()));
            mbuilder.setSection(NcStream.encodeSection(new Section(m.getShape())));
            builder.addMembers(mbuilder);
        }
        return builder.build();
    }

    public static PointStreamProto.PointFeature encodePointFeature(PointFeature pf) throws IOException {
        PointStreamProto.Location.Builder locBuilder = PointStreamProto.Location.newBuilder();
        locBuilder.setTime(pf.getObservationTime());
        if (!Double.isNaN(pf.getNominalTime()) && pf.getNominalTime() != pf.getObservationTime()) {
            locBuilder.setNomTime(pf.getNominalTime());
        }
        EarthLocation loc = pf.getLocation();
        locBuilder.setLat(loc.getLatitude());
        locBuilder.setLon(loc.getLongitude());
        if (!Double.isNaN(loc.getAltitude())) {
            locBuilder.setAlt(loc.getAltitude());
        }
        PointStreamProto.PointFeature.Builder builder = PointStreamProto.PointFeature.newBuilder();
        builder.setLoc(locBuilder);
        StructureData sdata = pf.getData();
        StructureMembers sm = sdata.getStructureMembers();
        int size = sm.getStructureSize();
        ByteBuffer bb = ByteBuffer.allocate(size);
        int stringno = 0;
        for (StructureMembers.Member m : sm.getMembers()) {
            if (m.getDataType() == DataType.STRING) {
                builder.addSdata(sdata.getScalarString(m));
                bb.putInt(stringno++);
                continue;
            }
            if (m.getDataType() == DataType.DOUBLE) {
                bb.putDouble(sdata.getScalarDouble(m));
                continue;
            }
            if (m.getDataType() == DataType.FLOAT) {
                bb.putFloat(sdata.getScalarFloat(m));
                continue;
            }
            if (m.getDataType() == DataType.INT) {
                bb.putInt(sdata.getScalarInt(m));
                continue;
            }
            if (m.getDataType() == DataType.SHORT) {
                bb.putShort(sdata.getScalarShort(m));
                continue;
            }
            if (m.getDataType() == DataType.BYTE) {
                bb.put(sdata.getScalarByte(m));
                continue;
            }
            if (m.getDataType() == DataType.CHAR) {
                for (char c : sdata.getJavaArrayChar(m)) {
                    bb.put((byte)c);
                }
                continue;
            }
            System.out.println(" unimplemented type = " + (Object)((Object)m.getDataType()));
        }
        builder.setData(ByteString.copyFrom(bb.array()));
        return builder.build();
    }

    public static PointStreamProto.StationList encodeStations(List<Station> stnList) throws IOException {
        PointStreamProto.StationList.Builder stnBuilder = PointStreamProto.StationList.newBuilder();
        for (Station loc : stnList) {
            PointStreamProto.Station.Builder locBuilder = PointStreamProto.Station.newBuilder();
            locBuilder.setId(loc.getName());
            locBuilder.setLat(loc.getLatitude());
            locBuilder.setLon(loc.getLongitude());
            if (!Double.isNaN(loc.getAltitude())) {
                locBuilder.setAlt(loc.getAltitude());
            }
            if (loc.getDescription() != null) {
                locBuilder.setDesc(loc.getDescription());
            }
            if (loc.getWmoId() != null) {
                locBuilder.setWmoId(loc.getWmoId());
            }
            stnBuilder.addStations(locBuilder);
        }
        return stnBuilder.build();
    }
}

